@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property consoleAccess
 * @property groups
 * @property replicationUser
 * @property username
 */
public data class GetBrokerUser(
    public val consoleAccess: Boolean,
    public val groups: List<String>,
    public val replicationUser: Boolean,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.GetBrokerUser): GetBrokerUser =
            GetBrokerUser(
                consoleAccess = javaType.consoleAccess(),
                groups = javaType.groups().map({ args0 -> args0 }),
                replicationUser = javaType.replicationUser(),
                username = javaType.username(),
            )
    }
}
