@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceTypeOfferings.
 * @property brokerInstanceOptions Option for host instance type. See Broker Instance Options below.
 * @property engineType Broker's engine type.
 * @property hostInstanceType Broker's instance type.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property storageType Broker's storage type.
 */
public data class GetInstanceTypeOfferingsResult(
    public val brokerInstanceOptions: List<GetInstanceTypeOfferingsBrokerInstanceOption>,
    public val engineType: String? = null,
    public val hostInstanceType: String? = null,
    public val id: String,
    public val storageType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.GetInstanceTypeOfferingsResult):
            GetInstanceTypeOfferingsResult = GetInstanceTypeOfferingsResult(
            brokerInstanceOptions = javaType.brokerInstanceOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mq.kotlin.outputs.GetInstanceTypeOfferingsBrokerInstanceOption.Companion.toKotlin(args0)
                })
            }),
            engineType = javaType.engineType().map({ args0 -> args0 }).orElse(null),
            hostInstanceType = javaType.hostInstanceType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            storageType = javaType.storageType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
