@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.kotlin.outputs.ClusterBrokerNodeGroupInfo
import com.pulumi.aws.msk.kotlin.outputs.ClusterClientAuthentication
import com.pulumi.aws.msk.kotlin.outputs.ClusterConfigurationInfo
import com.pulumi.aws.msk.kotlin.outputs.ClusterEncryptionInfo
import com.pulumi.aws.msk.kotlin.outputs.ClusterLoggingInfo
import com.pulumi.aws.msk.kotlin.outputs.ClusterOpenMonitoring
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.msk.kotlin.outputs.ClusterBrokerNodeGroupInfo.Companion.toKotlin as clusterBrokerNodeGroupInfoToKotlin
import com.pulumi.aws.msk.kotlin.outputs.ClusterClientAuthentication.Companion.toKotlin as clusterClientAuthenticationToKotlin
import com.pulumi.aws.msk.kotlin.outputs.ClusterConfigurationInfo.Companion.toKotlin as clusterConfigurationInfoToKotlin
import com.pulumi.aws.msk.kotlin.outputs.ClusterEncryptionInfo.Companion.toKotlin as clusterEncryptionInfoToKotlin
import com.pulumi.aws.msk.kotlin.outputs.ClusterLoggingInfo.Companion.toKotlin as clusterLoggingInfoToKotlin
import com.pulumi.aws.msk.kotlin.outputs.ClusterOpenMonitoring.Companion.toKotlin as clusterOpenMonitoringToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.aws.msk.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Manages an Amazon MSK cluster.
 * > **Note:** This resource manages _provisioned_ clusters. To manage a _serverless_ Amazon MSK cluster, use the `aws.msk.ServerlessCluster` resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.msk.Cluster;
 * import com.pulumi.aws.msk.ClusterArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterEncryptionInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringArgs;
 * import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusArgs;
 * import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusJmxExporterArgs;
 * import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusNodeExporterArgs;
 * import com.pulumi.aws.msk.inputs.ClusterLoggingInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsArgs;
 * import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs;
 * import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsFirehoseArgs;
 * import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpc = new Vpc("vpc", VpcArgs.builder()
 *             .cidrBlock("192.168.0.0/22")
 *             .build());
 *         final var azs = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .build());
 *         var subnetAz1 = new Subnet("subnetAz1", SubnetArgs.builder()
 *             .availabilityZone(azs.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .cidrBlock("192.168.0.0/24")
 *             .vpcId(vpc.id())
 *             .build());
 *         var subnetAz2 = new Subnet("subnetAz2", SubnetArgs.builder()
 *             .availabilityZone(azs.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
 *             .cidrBlock("192.168.1.0/24")
 *             .vpcId(vpc.id())
 *             .build());
 *         var subnetAz3 = new Subnet("subnetAz3", SubnetArgs.builder()
 *             .availabilityZone(azs.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[2]))
 *             .cidrBlock("192.168.2.0/24")
 *             .vpcId(vpc.id())
 *             .build());
 *         var sg = new SecurityGroup("sg", SecurityGroupArgs.builder()
 *             .vpcId(vpc.id())
 *             .build());
 *         var kms = new Key("kms", KeyArgs.builder()
 *             .description("example")
 *             .build());
 *         var test = new LogGroup("test");
 *         var bucket = new BucketV2("bucket");
 *         var bucketAcl = new BucketAclV2("bucketAcl", BucketAclV2Args.builder()
 *             .bucket(bucket.id())
 *             .acl("private")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var firehoseRole = new Role("firehoseRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(firehoseRole.arn())
 *                 .bucketArn(bucket.arn())
 *                 .build())
 *             .tags(Map.of("LogDeliveryEnabled", "placeholder"))
 *             .build());
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .kafkaVersion("3.2.0")
 *             .numberOfBrokerNodes(3)
 *             .brokerNodeGroupInfo(ClusterBrokerNodeGroupInfoArgs.builder()
 *                 .instanceType("kafka.m5.large")
 *                 .clientSubnets(
 *                     subnetAz1.id(),
 *                     subnetAz2.id(),
 *                     subnetAz3.id())
 *                 .storageInfo(ClusterBrokerNodeGroupInfoStorageInfoArgs.builder()
 *                     .ebsStorageInfo(ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs.builder()
 *                         .volumeSize(1000)
 *                         .build())
 *                     .build())
 *                 .securityGroups(sg.id())
 *                 .build())
 *             .encryptionInfo(ClusterEncryptionInfoArgs.builder()
 *                 .encryptionAtRestKmsKeyArn(kms.arn())
 *                 .build())
 *             .openMonitoring(ClusterOpenMonitoringArgs.builder()
 *                 .prometheus(ClusterOpenMonitoringPrometheusArgs.builder()
 *                     .jmxExporter(ClusterOpenMonitoringPrometheusJmxExporterArgs.builder()
 *                         .enabledInBroker(true)
 *                         .build())
 *                     .nodeExporter(ClusterOpenMonitoringPrometheusNodeExporterArgs.builder()
 *                         .enabledInBroker(true)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .loggingInfo(ClusterLoggingInfoArgs.builder()
 *                 .brokerLogs(ClusterLoggingInfoBrokerLogsArgs.builder()
 *                     .cloudwatchLogs(ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs.builder()
 *                         .enabled(true)
 *                         .logGroup(test.name())
 *                         .build())
 *                     .firehose(ClusterLoggingInfoBrokerLogsFirehoseArgs.builder()
 *                         .enabled(true)
 *                         .deliveryStream(testStream.name())
 *                         .build())
 *                     .s3(ClusterLoggingInfoBrokerLogsS3Args.builder()
 *                         .enabled(true)
 *                         .bucket(bucket.id())
 *                         .prefix("logs/msk-")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         ctx.export("zookeeperConnectString", example.zookeeperConnectString());
 *         ctx.export("bootstrapBrokersTls", example.bootstrapBrokersTls());
 *     }
 * }
 * ```
 * ### With volume_throughput argument
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.Cluster;
 * import com.pulumi.aws.msk.ClusterArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .kafkaVersion("2.7.1")
 *             .numberOfBrokerNodes(3)
 *             .brokerNodeGroupInfo(ClusterBrokerNodeGroupInfoArgs.builder()
 *                 .instanceType("kafka.m5.4xlarge")
 *                 .clientSubnets(
 *                     aws_subnet.subnet_az1().id(),
 *                     aws_subnet.subnet_az2().id(),
 *                     aws_subnet.subnet_az3().id())
 *                 .storageInfo(ClusterBrokerNodeGroupInfoStorageInfoArgs.builder()
 *                     .ebsStorageInfo(ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs.builder()
 *                         .provisionedThroughput(ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs.builder()
 *                             .enabled(true)
 *                             .volumeThroughput(250)
 *                             .build())
 *                         .volumeSize(1000)
 *                         .build())
 *                     .build())
 *                 .securityGroups(aws_security_group.sg().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK clusters using the cluster `arn`. For example:
 * ```sh
 *  $ pulumi import aws:msk/cluster:Cluster example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 *
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.aws.msk.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster. Contains a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `PLAINTEXT` or `TLS_PLAINTEXT`. The resource sorts values alphabetically. AWS may not always return all endpoints so this value is not guaranteed to be stable across applies.
     */
    public val bootstrapBrokers: Output<String>
        get() = javaResource.bootstrapBrokers().applyValue({ args0 -> args0 })

    /**
     * One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     */
    public val bootstrapBrokersPublicSaslIam: Output<String>
        get() = javaResource.bootstrapBrokersPublicSaslIam().applyValue({ args0 -> args0 })

    /**
     * One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     */
    public val bootstrapBrokersPublicSaslScram: Output<String>
        get() = javaResource.bootstrapBrokersPublicSaslScram().applyValue({ args0 -> args0 })

    /**
     * One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     */
    public val bootstrapBrokersPublicTls: Output<String>
        get() = javaResource.bootstrapBrokersPublicTls().applyValue({ args0 -> args0 })

    /**
     * One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     */
    public val bootstrapBrokersSaslIam: Output<String>
        get() = javaResource.bootstrapBrokersSaslIam().applyValue({ args0 -> args0 })

    /**
     * One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     */
    public val bootstrapBrokersSaslScram: Output<String>
        get() = javaResource.bootstrapBrokersSaslScram().applyValue({ args0 -> args0 })

    /**
     * One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     */
    public val bootstrapBrokersTls: Output<String>
        get() = javaResource.bootstrapBrokersTls().applyValue({ args0 -> args0 })

    /**
     * A string containing one or more DNS names (or IP addresses) and SASL IAM port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
     */
    public val bootstrapBrokersVpcConnectivitySaslIam: Output<String>
        get() = javaResource.bootstrapBrokersVpcConnectivitySaslIam().applyValue({ args0 -> args0 })

    /**
     * A string containing one or more DNS names (or IP addresses) and SASL SCRAM port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
     */
    public val bootstrapBrokersVpcConnectivitySaslScram: Output<String>
        get() = javaResource.bootstrapBrokersVpcConnectivitySaslScram().applyValue({ args0 -> args0 })

    /**
     * A string containing one or more DNS names (or IP addresses) and TLS port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
     */
    public val bootstrapBrokersVpcConnectivityTls: Output<String>
        get() = javaResource.bootstrapBrokersVpcConnectivityTls().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the broker nodes of the Kafka cluster.
     */
    public val brokerNodeGroupInfo: Output<ClusterBrokerNodeGroupInfo>
        get() = javaResource.brokerNodeGroupInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterBrokerNodeGroupInfoToKotlin(args0)
            })
        })

    /**
     * Configuration block for specifying a client authentication. See below.
     */
    public val clientAuthentication: Output<ClusterClientAuthentication>?
        get() = javaResource.clientAuthentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterClientAuthenticationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the MSK cluster.
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * UUID of the MSK cluster, for use in IAM policies.
     */
    public val clusterUuid: Output<String>
        get() = javaResource.clusterUuid().applyValue({ args0 -> args0 })

    /**
     * Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
     */
    public val configurationInfo: Output<ClusterConfigurationInfo>?
        get() = javaResource.configurationInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterConfigurationInfoToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Current version of the MSK Cluster used for updates, e.g., `K13V1IB3VIYZZH`
     * * `encryption_info.0.encryption_at_rest_kms_key_arn` - The ARN of the KMS key used for encryption at rest of the broker data volumes.
     */
    public val currentVersion: Output<String>
        get() = javaResource.currentVersion().applyValue({ args0 -> args0 })

    /**
     * Configuration block for specifying encryption. See below.
     */
    public val encryptionInfo: Output<ClusterEncryptionInfo>?
        get() = javaResource.encryptionInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterEncryptionInfoToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
     */
    public val enhancedMonitoring: Output<String>?
        get() = javaResource.enhancedMonitoring().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify the desired Kafka software version.
     */
    public val kafkaVersion: Output<String>
        get() = javaResource.kafkaVersion().applyValue({ args0 -> args0 })

    /**
     * Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
     */
    public val loggingInfo: Output<ClusterLoggingInfo>?
        get() = javaResource.loggingInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterLoggingInfoToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
     */
    public val numberOfBrokerNodes: Output<Int>
        get() = javaResource.numberOfBrokerNodes().applyValue({ args0 -> args0 })

    /**
     * Configuration block for JMX and Node monitoring for the MSK cluster. See below.
     */
    public val openMonitoring: Output<ClusterOpenMonitoring>?
        get() = javaResource.openMonitoring().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterOpenMonitoringToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
     */
    public val storageMode: Output<String>
        get() = javaResource.storageMode().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
     */
    public val zookeeperConnectString: Output<String>
        get() = javaResource.zookeeperConnectString().applyValue({ args0 -> args0 })

    /**
     * A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster via TLS. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
     */
    public val zookeeperConnectStringTls: Output<String>
        get() = javaResource.zookeeperConnectStringTls().applyValue({ args0 -> args0 })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.msk.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.aws.msk.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit):
    Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
