@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.ClusterArgs.builder
import com.pulumi.aws.msk.kotlin.inputs.ClusterBrokerNodeGroupInfoArgs
import com.pulumi.aws.msk.kotlin.inputs.ClusterBrokerNodeGroupInfoArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.ClusterClientAuthenticationArgs
import com.pulumi.aws.msk.kotlin.inputs.ClusterClientAuthenticationArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.ClusterConfigurationInfoArgs
import com.pulumi.aws.msk.kotlin.inputs.ClusterConfigurationInfoArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.ClusterEncryptionInfoArgs
import com.pulumi.aws.msk.kotlin.inputs.ClusterEncryptionInfoArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.ClusterLoggingInfoArgs
import com.pulumi.aws.msk.kotlin.inputs.ClusterLoggingInfoArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.ClusterOpenMonitoringArgs
import com.pulumi.aws.msk.kotlin.inputs.ClusterOpenMonitoringArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon MSK cluster.
 * > **Note:** This resource manages _provisioned_ clusters. To manage a _serverless_ Amazon MSK cluster, use the `aws.msk.ServerlessCluster` resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.msk.Cluster;
 * import com.pulumi.aws.msk.ClusterArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterEncryptionInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringArgs;
 * import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusArgs;
 * import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusJmxExporterArgs;
 * import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusNodeExporterArgs;
 * import com.pulumi.aws.msk.inputs.ClusterLoggingInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsArgs;
 * import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs;
 * import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsFirehoseArgs;
 * import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpc = new Vpc("vpc", VpcArgs.builder()
 *             .cidrBlock("192.168.0.0/22")
 *             .build());
 *         final var azs = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .build());
 *         var subnetAz1 = new Subnet("subnetAz1", SubnetArgs.builder()
 *             .availabilityZone(azs.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .cidrBlock("192.168.0.0/24")
 *             .vpcId(vpc.id())
 *             .build());
 *         var subnetAz2 = new Subnet("subnetAz2", SubnetArgs.builder()
 *             .availabilityZone(azs.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
 *             .cidrBlock("192.168.1.0/24")
 *             .vpcId(vpc.id())
 *             .build());
 *         var subnetAz3 = new Subnet("subnetAz3", SubnetArgs.builder()
 *             .availabilityZone(azs.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[2]))
 *             .cidrBlock("192.168.2.0/24")
 *             .vpcId(vpc.id())
 *             .build());
 *         var sg = new SecurityGroup("sg", SecurityGroupArgs.builder()
 *             .vpcId(vpc.id())
 *             .build());
 *         var kms = new Key("kms", KeyArgs.builder()
 *             .description("example")
 *             .build());
 *         var test = new LogGroup("test");
 *         var bucket = new BucketV2("bucket");
 *         var bucketAcl = new BucketAclV2("bucketAcl", BucketAclV2Args.builder()
 *             .bucket(bucket.id())
 *             .acl("private")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var firehoseRole = new Role("firehoseRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(firehoseRole.arn())
 *                 .bucketArn(bucket.arn())
 *                 .build())
 *             .tags(Map.of("LogDeliveryEnabled", "placeholder"))
 *             .build());
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .kafkaVersion("3.2.0")
 *             .numberOfBrokerNodes(3)
 *             .brokerNodeGroupInfo(ClusterBrokerNodeGroupInfoArgs.builder()
 *                 .instanceType("kafka.m5.large")
 *                 .clientSubnets(
 *                     subnetAz1.id(),
 *                     subnetAz2.id(),
 *                     subnetAz3.id())
 *                 .storageInfo(ClusterBrokerNodeGroupInfoStorageInfoArgs.builder()
 *                     .ebsStorageInfo(ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs.builder()
 *                         .volumeSize(1000)
 *                         .build())
 *                     .build())
 *                 .securityGroups(sg.id())
 *                 .build())
 *             .encryptionInfo(ClusterEncryptionInfoArgs.builder()
 *                 .encryptionAtRestKmsKeyArn(kms.arn())
 *                 .build())
 *             .openMonitoring(ClusterOpenMonitoringArgs.builder()
 *                 .prometheus(ClusterOpenMonitoringPrometheusArgs.builder()
 *                     .jmxExporter(ClusterOpenMonitoringPrometheusJmxExporterArgs.builder()
 *                         .enabledInBroker(true)
 *                         .build())
 *                     .nodeExporter(ClusterOpenMonitoringPrometheusNodeExporterArgs.builder()
 *                         .enabledInBroker(true)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .loggingInfo(ClusterLoggingInfoArgs.builder()
 *                 .brokerLogs(ClusterLoggingInfoBrokerLogsArgs.builder()
 *                     .cloudwatchLogs(ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs.builder()
 *                         .enabled(true)
 *                         .logGroup(test.name())
 *                         .build())
 *                     .firehose(ClusterLoggingInfoBrokerLogsFirehoseArgs.builder()
 *                         .enabled(true)
 *                         .deliveryStream(testStream.name())
 *                         .build())
 *                     .s3(ClusterLoggingInfoBrokerLogsS3Args.builder()
 *                         .enabled(true)
 *                         .bucket(bucket.id())
 *                         .prefix("logs/msk-")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         ctx.export("zookeeperConnectString", example.zookeeperConnectString());
 *         ctx.export("bootstrapBrokersTls", example.bootstrapBrokersTls());
 *     }
 * }
 * ```
 * ### With volume_throughput argument
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.Cluster;
 * import com.pulumi.aws.msk.ClusterArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs;
 * import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .kafkaVersion("2.7.1")
 *             .numberOfBrokerNodes(3)
 *             .brokerNodeGroupInfo(ClusterBrokerNodeGroupInfoArgs.builder()
 *                 .instanceType("kafka.m5.4xlarge")
 *                 .clientSubnets(
 *                     aws_subnet.subnet_az1().id(),
 *                     aws_subnet.subnet_az2().id(),
 *                     aws_subnet.subnet_az3().id())
 *                 .storageInfo(ClusterBrokerNodeGroupInfoStorageInfoArgs.builder()
 *                     .ebsStorageInfo(ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs.builder()
 *                         .provisionedThroughput(ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs.builder()
 *                             .enabled(true)
 *                             .volumeThroughput(250)
 *                             .build())
 *                         .volumeSize(1000)
 *                         .build())
 *                     .build())
 *                 .securityGroups(aws_security_group.sg().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK clusters using the cluster `arn`. For example:
 * ```sh
 *  $ pulumi import aws:msk/cluster:Cluster example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 * @property brokerNodeGroupInfo Configuration block for the broker nodes of the Kafka cluster.
 * @property clientAuthentication Configuration block for specifying a client authentication. See below.
 * @property clusterName Name of the MSK cluster.
 * @property configurationInfo Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
 * @property encryptionInfo Configuration block for specifying encryption. See below.
 * @property enhancedMonitoring Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
 * @property kafkaVersion Specify the desired Kafka software version.
 * @property loggingInfo Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
 * @property numberOfBrokerNodes The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
 * @property openMonitoring Configuration block for JMX and Node monitoring for the MSK cluster. See below.
 * @property storageMode Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterArgs(
    public val brokerNodeGroupInfo: Output<ClusterBrokerNodeGroupInfoArgs>? = null,
    public val clientAuthentication: Output<ClusterClientAuthenticationArgs>? = null,
    public val clusterName: Output<String>? = null,
    public val configurationInfo: Output<ClusterConfigurationInfoArgs>? = null,
    public val encryptionInfo: Output<ClusterEncryptionInfoArgs>? = null,
    public val enhancedMonitoring: Output<String>? = null,
    public val kafkaVersion: Output<String>? = null,
    public val loggingInfo: Output<ClusterLoggingInfoArgs>? = null,
    public val numberOfBrokerNodes: Output<Int>? = null,
    public val openMonitoring: Output<ClusterOpenMonitoringArgs>? = null,
    public val storageMode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.msk.ClusterArgs = com.pulumi.aws.msk.ClusterArgs.builder()
        .brokerNodeGroupInfo(
            brokerNodeGroupInfo?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .clientAuthentication(
            clientAuthentication?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .clusterName(clusterName?.applyValue({ args0 -> args0 }))
        .configurationInfo(configurationInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .encryptionInfo(encryptionInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .enhancedMonitoring(enhancedMonitoring?.applyValue({ args0 -> args0 }))
        .kafkaVersion(kafkaVersion?.applyValue({ args0 -> args0 }))
        .loggingInfo(loggingInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .numberOfBrokerNodes(numberOfBrokerNodes?.applyValue({ args0 -> args0 }))
        .openMonitoring(openMonitoring?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .storageMode(storageMode?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var brokerNodeGroupInfo: Output<ClusterBrokerNodeGroupInfoArgs>? = null

    private var clientAuthentication: Output<ClusterClientAuthenticationArgs>? = null

    private var clusterName: Output<String>? = null

    private var configurationInfo: Output<ClusterConfigurationInfoArgs>? = null

    private var encryptionInfo: Output<ClusterEncryptionInfoArgs>? = null

    private var enhancedMonitoring: Output<String>? = null

    private var kafkaVersion: Output<String>? = null

    private var loggingInfo: Output<ClusterLoggingInfoArgs>? = null

    private var numberOfBrokerNodes: Output<Int>? = null

    private var openMonitoring: Output<ClusterOpenMonitoringArgs>? = null

    private var storageMode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block for the broker nodes of the Kafka cluster.
     */
    @JvmName("obwhcfkwcqaharyg")
    public suspend fun brokerNodeGroupInfo(`value`: Output<ClusterBrokerNodeGroupInfoArgs>) {
        this.brokerNodeGroupInfo = value
    }

    /**
     * @param value Configuration block for specifying a client authentication. See below.
     */
    @JvmName("sqpcplyijaxrcbvi")
    public suspend fun clientAuthentication(`value`: Output<ClusterClientAuthenticationArgs>) {
        this.clientAuthentication = value
    }

    /**
     * @param value Name of the MSK cluster.
     */
    @JvmName("vdkxshkjdyouipsj")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
     */
    @JvmName("ldftjqcdkatwqmib")
    public suspend fun configurationInfo(`value`: Output<ClusterConfigurationInfoArgs>) {
        this.configurationInfo = value
    }

    /**
     * @param value Configuration block for specifying encryption. See below.
     */
    @JvmName("tvmgnjhkvbfjlhbp")
    public suspend fun encryptionInfo(`value`: Output<ClusterEncryptionInfoArgs>) {
        this.encryptionInfo = value
    }

    /**
     * @param value Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
     */
    @JvmName("hieuufkjknoihfbi")
    public suspend fun enhancedMonitoring(`value`: Output<String>) {
        this.enhancedMonitoring = value
    }

    /**
     * @param value Specify the desired Kafka software version.
     */
    @JvmName("htujubukmxhnsxbd")
    public suspend fun kafkaVersion(`value`: Output<String>) {
        this.kafkaVersion = value
    }

    /**
     * @param value Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
     */
    @JvmName("oattnjdduuuaamwa")
    public suspend fun loggingInfo(`value`: Output<ClusterLoggingInfoArgs>) {
        this.loggingInfo = value
    }

    /**
     * @param value The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
     */
    @JvmName("xpyrnlbrfeyklagh")
    public suspend fun numberOfBrokerNodes(`value`: Output<Int>) {
        this.numberOfBrokerNodes = value
    }

    /**
     * @param value Configuration block for JMX and Node monitoring for the MSK cluster. See below.
     */
    @JvmName("tqxxeigmajtvjbyy")
    public suspend fun openMonitoring(`value`: Output<ClusterOpenMonitoringArgs>) {
        this.openMonitoring = value
    }

    /**
     * @param value Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
     */
    @JvmName("pirrookyyxdxacga")
    public suspend fun storageMode(`value`: Output<String>) {
        this.storageMode = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fkhlsqdkbssnknxu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the broker nodes of the Kafka cluster.
     */
    @JvmName("iprrainigplvkacr")
    public suspend fun brokerNodeGroupInfo(`value`: ClusterBrokerNodeGroupInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brokerNodeGroupInfo = mapped
    }

    /**
     * @param argument Configuration block for the broker nodes of the Kafka cluster.
     */
    @JvmName("afasjrppuedoohoo")
    public suspend
    fun brokerNodeGroupInfo(argument: suspend ClusterBrokerNodeGroupInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterBrokerNodeGroupInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.brokerNodeGroupInfo = mapped
    }

    /**
     * @param value Configuration block for specifying a client authentication. See below.
     */
    @JvmName("lihxdahylhpggpma")
    public suspend fun clientAuthentication(`value`: ClusterClientAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAuthentication = mapped
    }

    /**
     * @param argument Configuration block for specifying a client authentication. See below.
     */
    @JvmName("fdotsljqxbbgepgr")
    public suspend
    fun clientAuthentication(argument: suspend ClusterClientAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterClientAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientAuthentication = mapped
    }

    /**
     * @param value Name of the MSK cluster.
     */
    @JvmName("ogifjendtcpisgcv")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
     */
    @JvmName("tvuxovmeorxgaxyt")
    public suspend fun configurationInfo(`value`: ClusterConfigurationInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationInfo = mapped
    }

    /**
     * @param argument Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
     */
    @JvmName("qynurxofpdrwpkqb")
    public suspend
    fun configurationInfo(argument: suspend ClusterConfigurationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterConfigurationInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configurationInfo = mapped
    }

    /**
     * @param value Configuration block for specifying encryption. See below.
     */
    @JvmName("uydwsgotrlvtcylv")
    public suspend fun encryptionInfo(`value`: ClusterEncryptionInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionInfo = mapped
    }

    /**
     * @param argument Configuration block for specifying encryption. See below.
     */
    @JvmName("afmmngtklgsbqmen")
    public suspend fun encryptionInfo(argument: suspend ClusterEncryptionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterEncryptionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionInfo = mapped
    }

    /**
     * @param value Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
     */
    @JvmName("xlmericjduwoxnro")
    public suspend fun enhancedMonitoring(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enhancedMonitoring = mapped
    }

    /**
     * @param value Specify the desired Kafka software version.
     */
    @JvmName("jvtbjccxqptpvdun")
    public suspend fun kafkaVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaVersion = mapped
    }

    /**
     * @param value Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
     */
    @JvmName("lvcedxbibjsboqmf")
    public suspend fun loggingInfo(`value`: ClusterLoggingInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingInfo = mapped
    }

    /**
     * @param argument Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
     */
    @JvmName("jpiokcqymvtqdymd")
    public suspend fun loggingInfo(argument: suspend ClusterLoggingInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterLoggingInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loggingInfo = mapped
    }

    /**
     * @param value The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
     */
    @JvmName("ssbcchueddirurjy")
    public suspend fun numberOfBrokerNodes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfBrokerNodes = mapped
    }

    /**
     * @param value Configuration block for JMX and Node monitoring for the MSK cluster. See below.
     */
    @JvmName("bkcibvvajnycoqfw")
    public suspend fun openMonitoring(`value`: ClusterOpenMonitoringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openMonitoring = mapped
    }

    /**
     * @param argument Configuration block for JMX and Node monitoring for the MSK cluster. See below.
     */
    @JvmName("krqypdsfjkvxmdxo")
    public suspend fun openMonitoring(argument: suspend ClusterOpenMonitoringArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterOpenMonitoringArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.openMonitoring = mapped
    }

    /**
     * @param value Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
     */
    @JvmName("ghnhlljdwoljhahp")
    public suspend fun storageMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageMode = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xewcukgabyjrjxcx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jupiccbxwhlydujs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        brokerNodeGroupInfo = brokerNodeGroupInfo,
        clientAuthentication = clientAuthentication,
        clusterName = clusterName,
        configurationInfo = configurationInfo,
        encryptionInfo = encryptionInfo,
        enhancedMonitoring = enhancedMonitoring,
        kafkaVersion = kafkaVersion,
        loggingInfo = loggingInfo,
        numberOfBrokerNodes = numberOfBrokerNodes,
        openMonitoring = openMonitoring,
        storageMode = storageMode,
        tags = tags,
    )
}
