@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.ClusterPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Managed Streaming for Kafka Cluster Policy.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.msk.ClusterPolicy;
 * import com.pulumi.aws.msk.ClusterPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         var example = new ClusterPolicy("example", ClusterPolicyArgs.builder()
 *             .clusterArn(aws_msk_cluster.example().arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "ExampleMskClusterPolicy"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", String.format("arn:%s:iam::%s:root", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         )),
 *                         jsonProperty("Action", jsonArray(
 *                             "kafka:Describe*",
 *                             "kafka:Get*",
 *                             "kafka:CreateVpcConnection",
 *                             "kafka:GetBootstrapBrokers"
 *                         )),
 *                         jsonProperty("Resource", aws_msk_cluster.example().arn())
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Managed Streaming for Kafka Cluster Policy using the `cluster_arn`. For example:
 * ```sh
 *  $ pulumi import aws:msk/clusterPolicy:ClusterPolicy example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 * @property clusterArn The Amazon Resource Name (ARN) that uniquely identifies the cluster.
 * @property policy Resource policy for cluster.
 */
public data class ClusterPolicyArgs(
    public val clusterArn: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.ClusterPolicyArgs> {
    override fun toJava(): com.pulumi.aws.msk.ClusterPolicyArgs =
        com.pulumi.aws.msk.ClusterPolicyArgs.builder()
            .clusterArn(clusterArn?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterPolicyArgs].
 */
@PulumiTagMarker
public class ClusterPolicyArgsBuilder internal constructor() {
    private var clusterArn: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     */
    @JvmName("jdeikvmpvugqsuol")
    public suspend fun clusterArn(`value`: Output<String>) {
        this.clusterArn = value
    }

    /**
     * @param value Resource policy for cluster.
     */
    @JvmName("vtbrbdwxdjsujrud")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     */
    @JvmName("ajcmbxkbvkumefql")
    public suspend fun clusterArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterArn = mapped
    }

    /**
     * @param value Resource policy for cluster.
     */
    @JvmName("pevfwrkkdwjhmoom")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): ClusterPolicyArgs = ClusterPolicyArgs(
        clusterArn = clusterArn,
        policy = policy,
    )
}
