@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Configuration].
 */
@PulumiTagMarker
public class ConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationArgs = ConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationArgsBuilder.() -> Unit) {
        val builder = ConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Configuration {
        val builtJavaResource = com.pulumi.aws.msk.Configuration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Configuration(builtJavaResource)
    }
}

/**
 * Manages an Amazon Managed Streaming for Kafka configuration. More information can be found on the [MSK Developer Guide](https://docs.aws.amazon.com/msk/latest/developerguide/msk-configuration.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.Configuration;
 * import com.pulumi.aws.msk.ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Configuration("example", ConfigurationArgs.builder()
 *             .kafkaVersions("2.1.0")
 *             .serverProperties("""
 * auto.create.topics.enable = true
 * delete.topic.enable = true
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK configurations using the configuration ARN. For example:
 * ```sh
 *  $ pulumi import aws:msk/configuration:Configuration example arn:aws:kafka:us-west-2:123456789012:configuration/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 *
 */
public class Configuration internal constructor(
    override val javaResource: com.pulumi.aws.msk.Configuration,
) : KotlinCustomResource(javaResource, ConfigurationMapper) {
    /**
     * Amazon Resource Name (ARN) of the configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of Apache Kafka versions which can use this configuration.
     */
    public val kafkaVersions: Output<List<String>>?
        get() = javaResource.kafkaVersions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Latest revision of the configuration.
     */
    public val latestRevision: Output<Int>
        get() = javaResource.latestRevision().applyValue({ args0 -> args0 })

    /**
     * Name of the configuration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Contents of the server.properties file. Supported properties are documented in the [MSK Developer Guide](https://docs.aws.amazon.com/msk/latest/developerguide/msk-configuration-properties.html).
     */
    public val serverProperties: Output<String>
        get() = javaResource.serverProperties().applyValue({ args0 -> args0 })
}

public object ConfigurationMapper : ResourceMapper<Configuration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.msk.Configuration::class == javaResource::class

    override fun map(javaResource: Resource): Configuration = Configuration(
        javaResource as
            com.pulumi.aws.msk.Configuration,
    )
}

/**
 * @see [Configuration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Configuration].
 */
public suspend fun configuration(
    name: String,
    block: suspend ConfigurationResourceBuilder.() -> Unit,
): Configuration {
    val builder = ConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Configuration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configuration(name: String): Configuration {
    val builder = ConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
