@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.MskFunctions.getBrokerNodesPlain
import com.pulumi.aws.msk.MskFunctions.getClusterPlain
import com.pulumi.aws.msk.MskFunctions.getConfigurationPlain
import com.pulumi.aws.msk.MskFunctions.getKafkaVersionPlain
import com.pulumi.aws.msk.MskFunctions.getVpcConnectionPlain
import com.pulumi.aws.msk.kotlin.inputs.GetBrokerNodesPlainArgs
import com.pulumi.aws.msk.kotlin.inputs.GetBrokerNodesPlainArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.msk.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.GetConfigurationPlainArgs
import com.pulumi.aws.msk.kotlin.inputs.GetConfigurationPlainArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.GetKafkaVersionPlainArgs
import com.pulumi.aws.msk.kotlin.inputs.GetKafkaVersionPlainArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.GetVpcConnectionPlainArgs
import com.pulumi.aws.msk.kotlin.inputs.GetVpcConnectionPlainArgsBuilder
import com.pulumi.aws.msk.kotlin.outputs.GetBrokerNodesResult
import com.pulumi.aws.msk.kotlin.outputs.GetClusterResult
import com.pulumi.aws.msk.kotlin.outputs.GetConfigurationResult
import com.pulumi.aws.msk.kotlin.outputs.GetKafkaVersionResult
import com.pulumi.aws.msk.kotlin.outputs.GetVpcConnectionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.msk.kotlin.outputs.GetBrokerNodesResult.Companion.toKotlin as getBrokerNodesResultToKotlin
import com.pulumi.aws.msk.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.msk.kotlin.outputs.GetConfigurationResult.Companion.toKotlin as getConfigurationResultToKotlin
import com.pulumi.aws.msk.kotlin.outputs.GetKafkaVersionResult.Companion.toKotlin as getKafkaVersionResultToKotlin
import com.pulumi.aws.msk.kotlin.outputs.GetVpcConnectionResult.Companion.toKotlin as getVpcConnectionResultToKotlin

public object MskFunctions {
    /**
     * Get information on an Amazon MSK Broker Nodes.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.msk.MskFunctions;
     * import com.pulumi.aws.msk.inputs.GetBrokerNodesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MskFunctions.getBrokerNodes(GetBrokerNodesArgs.builder()
     *             .clusterArn(aws_msk_cluster.example().arn())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getBrokerNodes.
     * @return A collection of values returned by getBrokerNodes.
     */
    public suspend fun getBrokerNodes(argument: GetBrokerNodesPlainArgs): GetBrokerNodesResult =
        getBrokerNodesResultToKotlin(getBrokerNodesPlain(argument.toJava()).await())

    /**
     * @see [getBrokerNodes].
     * @param clusterArn ARN of the cluster the nodes belong to.
     * @return A collection of values returned by getBrokerNodes.
     */
    public suspend fun getBrokerNodes(clusterArn: String): GetBrokerNodesResult {
        val argument = GetBrokerNodesPlainArgs(
            clusterArn = clusterArn,
        )
        return getBrokerNodesResultToKotlin(getBrokerNodesPlain(argument.toJava()).await())
    }

    /**
     * @see [getBrokerNodes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;msk&#46;kotlin&#46;inputs&#46;GetBrokerNodesPlainArgs].
     * @return A collection of values returned by getBrokerNodes.
     */
    public suspend fun getBrokerNodes(argument: suspend GetBrokerNodesPlainArgsBuilder.() -> Unit):
        GetBrokerNodesResult {
        val builder = GetBrokerNodesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBrokerNodesResultToKotlin(getBrokerNodesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an Amazon MSK Cluster.
     * > **Note:** This data sources returns information on _provisioned_ clusters.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.msk.MskFunctions;
     * import com.pulumi.aws.msk.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MskFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterName("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName Name of the cluster.
     * @param tags Map of key-value pairs assigned to the cluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(clusterName: String, tags: Map<String, String>? = null):
        GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;msk&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an Amazon MSK Configuration.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.msk.MskFunctions;
     * import com.pulumi.aws.msk.inputs.GetConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MskFunctions.getConfiguration(GetConfigurationArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getConfiguration.
     * @return A collection of values returned by getConfiguration.
     */
    public suspend fun getConfiguration(argument: GetConfigurationPlainArgs): GetConfigurationResult =
        getConfigurationResultToKotlin(getConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getConfiguration].
     * @param name Name of the configuration.
     * @return A collection of values returned by getConfiguration.
     */
    public suspend fun getConfiguration(name: String): GetConfigurationResult {
        val argument = GetConfigurationPlainArgs(
            name = name,
        )
        return getConfigurationResultToKotlin(getConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;msk&#46;kotlin&#46;inputs&#46;GetConfigurationPlainArgs].
     * @return A collection of values returned by getConfiguration.
     */
    public suspend
    fun getConfiguration(argument: suspend GetConfigurationPlainArgsBuilder.() -> Unit):
        GetConfigurationResult {
        val builder = GetConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationResultToKotlin(getConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on a Amazon MSK Kafka Version
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.msk.MskFunctions;
     * import com.pulumi.aws.msk.inputs.GetKafkaVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var preferred = MskFunctions.getKafkaVersion(GetKafkaVersionArgs.builder()
     *             .preferredVersions(
     *                 "2.4.1.1",
     *                 "2.4.1",
     *                 "2.2.1")
     *             .build());
     *         final var example = MskFunctions.getKafkaVersion(GetKafkaVersionArgs.builder()
     *             .version("2.8.0")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getKafkaVersion.
     * @return A collection of values returned by getKafkaVersion.
     */
    public suspend fun getKafkaVersion(argument: GetKafkaVersionPlainArgs): GetKafkaVersionResult =
        getKafkaVersionResultToKotlin(getKafkaVersionPlain(argument.toJava()).await())

    /**
     * @see [getKafkaVersion].
     * @param preferredVersions Ordered list of preferred Kafka versions. The first match in this list will be returned. Either `preferred_versions` or `version` must be set.
     * @param version Version of MSK Kafka. For example 2.4.1.1 or "2.2.1" etc. Either `preferred_versions` or `version` must be set.
     * @return A collection of values returned by getKafkaVersion.
     */
    public suspend fun getKafkaVersion(
        preferredVersions: List<String>? = null,
        version: String? =
            null,
    ): GetKafkaVersionResult {
        val argument = GetKafkaVersionPlainArgs(
            preferredVersions = preferredVersions,
            version = version,
        )
        return getKafkaVersionResultToKotlin(getKafkaVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getKafkaVersion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;msk&#46;kotlin&#46;inputs&#46;GetKafkaVersionPlainArgs].
     * @return A collection of values returned by getKafkaVersion.
     */
    public suspend fun getKafkaVersion(argument: suspend GetKafkaVersionPlainArgsBuilder.() -> Unit):
        GetKafkaVersionResult {
        val builder = GetKafkaVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKafkaVersionResultToKotlin(getKafkaVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an Amazon MSK VPC Connection.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.msk.MskFunctions;
     * import com.pulumi.aws.msk.inputs.GetVpcConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MskFunctions.getVpcConnection(GetVpcConnectionArgs.builder()
     *             .arn(aws_msk_vpc_connection.example().arn())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcConnection.
     * @return A collection of values returned by getVpcConnection.
     */
    public suspend fun getVpcConnection(argument: GetVpcConnectionPlainArgs): GetVpcConnectionResult =
        getVpcConnectionResultToKotlin(getVpcConnectionPlain(argument.toJava()).await())

    /**
     * @see [getVpcConnection].
     * @param arn ARN of the VPC Connection.
     * @param tags Map of key-value pairs assigned to the VPC Connection.
     * @return A collection of values returned by getVpcConnection.
     */
    public suspend fun getVpcConnection(arn: String, tags: Map<String, String>? = null):
        GetVpcConnectionResult {
        val argument = GetVpcConnectionPlainArgs(
            arn = arn,
            tags = tags,
        )
        return getVpcConnectionResultToKotlin(getVpcConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcConnection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;msk&#46;kotlin&#46;inputs&#46;GetVpcConnectionPlainArgs].
     * @return A collection of values returned by getVpcConnection.
     */
    public suspend
    fun getVpcConnection(argument: suspend GetVpcConnectionPlainArgsBuilder.() -> Unit):
        GetVpcConnectionResult {
        val builder = GetVpcConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcConnectionResultToKotlin(getVpcConnectionPlain(builtArgument.toJava()).await())
    }
}
