@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.kotlin.outputs.ReplicatorKafkaCluster
import com.pulumi.aws.msk.kotlin.outputs.ReplicatorReplicationInfoList
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.msk.kotlin.outputs.ReplicatorKafkaCluster.Companion.toKotlin as replicatorKafkaClusterToKotlin
import com.pulumi.aws.msk.kotlin.outputs.ReplicatorReplicationInfoList.Companion.toKotlin as replicatorReplicationInfoListToKotlin

/**
 * Builder for [Replicator].
 */
@PulumiTagMarker
public class ReplicatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicatorArgs = ReplicatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicatorArgsBuilder.() -> Unit) {
        val builder = ReplicatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Replicator {
        val builtJavaResource = com.pulumi.aws.msk.Replicator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Replicator(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Managed Streaming for Kafka Replicator.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import MSK replicators using the replicator ARN. For example:
 * ```sh
 *  $ pulumi import aws:msk/replicator:Replicator example arn:aws:kafka:us-west-2:123456789012:configuration/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 *
 */
public class Replicator internal constructor(
    override val javaResource: com.pulumi.aws.msk.Replicator,
) : KotlinCustomResource(javaResource, ReplicatorMapper) {
    /**
     * ARN of the Replicator. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val currentVersion: Output<String>
        get() = javaResource.currentVersion().applyValue({ args0 -> args0 })

    /**
     * A summary description of the replicator.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of Kafka clusters which are targets of the replicator.
     */
    public val kafkaClusters: Output<List<ReplicatorKafkaCluster>>
        get() = javaResource.kafkaClusters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> replicatorKafkaClusterToKotlin(args0) })
            })
        })

    /**
     * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    public val replicationInfoList: Output<ReplicatorReplicationInfoList>
        get() = javaResource.replicationInfoList().applyValue({ args0 ->
            args0.let({ args0 ->
                replicatorReplicationInfoListToKotlin(args0)
            })
        })

    /**
     * The name of the replicator.
     */
    public val replicatorName: Output<String>
        get() = javaResource.replicatorName().applyValue({ args0 -> args0 })

    /**
     * The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
     */
    public val serviceExecutionRoleArn: Output<String>
        get() = javaResource.serviceExecutionRoleArn().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ReplicatorMapper : ResourceMapper<Replicator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.msk.Replicator::class == javaResource::class

    override fun map(javaResource: Resource): Replicator = Replicator(
        javaResource as
            com.pulumi.aws.msk.Replicator,
    )
}

/**
 * @see [Replicator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Replicator].
 */
public suspend fun replicator(name: String, block: suspend ReplicatorResourceBuilder.() -> Unit):
    Replicator {
    val builder = ReplicatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Replicator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicator(name: String): Replicator {
    val builder = ReplicatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
