@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.ReplicatorArgs.builder
import com.pulumi.aws.msk.kotlin.inputs.ReplicatorKafkaClusterArgs
import com.pulumi.aws.msk.kotlin.inputs.ReplicatorKafkaClusterArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.ReplicatorReplicationInfoListArgs
import com.pulumi.aws.msk.kotlin.inputs.ReplicatorReplicationInfoListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Managed Streaming for Kafka Replicator.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import MSK replicators using the replicator ARN. For example:
 * ```sh
 *  $ pulumi import aws:msk/replicator:Replicator example arn:aws:kafka:us-west-2:123456789012:configuration/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 * @property description A summary description of the replicator.
 * @property kafkaClusters A list of Kafka clusters which are targets of the replicator.
 * @property replicationInfoList A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
 * @property replicatorName The name of the replicator.
 * @property serviceExecutionRoleArn The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
 * @property tags
 */
public data class ReplicatorArgs(
    public val description: Output<String>? = null,
    public val kafkaClusters: Output<List<ReplicatorKafkaClusterArgs>>? = null,
    public val replicationInfoList: Output<ReplicatorReplicationInfoListArgs>? = null,
    public val replicatorName: Output<String>? = null,
    public val serviceExecutionRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.ReplicatorArgs> {
    override fun toJava(): com.pulumi.aws.msk.ReplicatorArgs =
        com.pulumi.aws.msk.ReplicatorArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .kafkaClusters(
                kafkaClusters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .replicationInfoList(
                replicationInfoList?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .replicatorName(replicatorName?.applyValue({ args0 -> args0 }))
            .serviceExecutionRoleArn(serviceExecutionRoleArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReplicatorArgs].
 */
@PulumiTagMarker
public class ReplicatorArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var kafkaClusters: Output<List<ReplicatorKafkaClusterArgs>>? = null

    private var replicationInfoList: Output<ReplicatorReplicationInfoListArgs>? = null

    private var replicatorName: Output<String>? = null

    private var serviceExecutionRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A summary description of the replicator.
     */
    @JvmName("nrluxhofkdmslbcr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("ickjkpawlluxbkey")
    public suspend fun kafkaClusters(`value`: Output<List<ReplicatorKafkaClusterArgs>>) {
        this.kafkaClusters = value
    }

    @JvmName("ubkxjonhlvywxitf")
    public suspend fun kafkaClusters(vararg values: Output<ReplicatorKafkaClusterArgs>) {
        this.kafkaClusters = Output.all(values.asList())
    }

    /**
     * @param values A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("jdyoiajtyadiukmq")
    public suspend fun kafkaClusters(values: List<Output<ReplicatorKafkaClusterArgs>>) {
        this.kafkaClusters = Output.all(values)
    }

    /**
     * @param value A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    @JvmName("isfhhjlscwlgesdg")
    public suspend fun replicationInfoList(`value`: Output<ReplicatorReplicationInfoListArgs>) {
        this.replicationInfoList = value
    }

    /**
     * @param value The name of the replicator.
     */
    @JvmName("eusoicxuifhkcrgv")
    public suspend fun replicatorName(`value`: Output<String>) {
        this.replicatorName = value
    }

    /**
     * @param value The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
     */
    @JvmName("xyaatwvbibxscbke")
    public suspend fun serviceExecutionRoleArn(`value`: Output<String>) {
        this.serviceExecutionRoleArn = value
    }

    /**
     * @param value
     */
    @JvmName("afdbwroqwjqmvkes")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A summary description of the replicator.
     */
    @JvmName("pumijvachvaoltgr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("voomdmpoheotshnw")
    public suspend fun kafkaClusters(`value`: List<ReplicatorKafkaClusterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaClusters = mapped
    }

    /**
     * @param argument A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("ubxowpuucgdfhiln")
    public suspend
    fun kafkaClusters(argument: List<suspend ReplicatorKafkaClusterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReplicatorKafkaClusterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kafkaClusters = mapped
    }

    /**
     * @param argument A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("gvpxgnnocybvcyui")
    public suspend fun kafkaClusters(
        vararg
        argument: suspend ReplicatorKafkaClusterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReplicatorKafkaClusterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kafkaClusters = mapped
    }

    /**
     * @param argument A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("rcrauikwjgcaunif")
    public suspend fun kafkaClusters(argument: suspend ReplicatorKafkaClusterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReplicatorKafkaClusterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.kafkaClusters = mapped
    }

    /**
     * @param values A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("kkopyungfjhkvtjk")
    public suspend fun kafkaClusters(vararg values: ReplicatorKafkaClusterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkaClusters = mapped
    }

    /**
     * @param value A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    @JvmName("yryawadujseyqshy")
    public suspend fun replicationInfoList(`value`: ReplicatorReplicationInfoListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationInfoList = mapped
    }

    /**
     * @param argument A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    @JvmName("yloxbptuotucorxg")
    public suspend
    fun replicationInfoList(argument: suspend ReplicatorReplicationInfoListArgsBuilder.() -> Unit) {
        val toBeMapped = ReplicatorReplicationInfoListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.replicationInfoList = mapped
    }

    /**
     * @param value The name of the replicator.
     */
    @JvmName("xltenjjxoiebbkkd")
    public suspend fun replicatorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicatorName = mapped
    }

    /**
     * @param value The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
     */
    @JvmName("vutjdjvqkfqelkqb")
    public suspend fun serviceExecutionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceExecutionRoleArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("hjgdujcqnkqgjddh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("fktrysfuvegwwrgg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReplicatorArgs = ReplicatorArgs(
        description = description,
        kafkaClusters = kafkaClusters,
        replicationInfoList = replicationInfoList,
        replicatorName = replicatorName,
        serviceExecutionRoleArn = serviceExecutionRoleArn,
        tags = tags,
    )
}
