@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ScramSecretAssociation].
 */
@PulumiTagMarker
public class ScramSecretAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScramSecretAssociationArgs = ScramSecretAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScramSecretAssociationArgsBuilder.() -> Unit) {
        val builder = ScramSecretAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ScramSecretAssociation {
        val builtJavaResource = com.pulumi.aws.msk.ScramSecretAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ScramSecretAssociation(builtJavaResource)
    }
}

/**
 * Associates SCRAM secrets stored in the Secrets Manager service with a Managed Streaming for Kafka (MSK) cluster.
 * > **Note:** The following assumes the MSK cluster has SASL/SCRAM authentication enabled. See below for example usage or refer to the [Username/Password Authentication](https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html) section of the MSK Developer Guide for more details.
 * To set up username and password authentication for a cluster, create an `aws.secretsmanager.Secret` resource and associate
 * a username and password with the secret with an `aws.secretsmanager.SecretVersion` resource. When creating a secret for the cluster,
 * the `name` must have the prefix `AmazonMSK_` and you must either use an existing custom AWS KMS key or create a new
 * custom AWS KMS key for your secret with the `aws.kms.Key` resource. It is important to note that a policy is required for the `aws.secretsmanager.Secret`
 * resource in order for Kafka to be able to read it. This policy is attached automatically when the `aws.msk.ScramSecretAssociation` is used,
 * however, this policy will not be in the state and as such, will present a diff on plan/apply. For that reason, you must use the `aws.secretsmanager.SecretPolicy`
 * resource](/docs/providers/aws/r/secretsmanager_secret_policy.html) as shown below in order to ensure that the state is in a clean state after the creation of secret and the association to the cluster.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.Cluster;
 * import com.pulumi.aws.msk.ClusterArgs;
 * import com.pulumi.aws.msk.inputs.ClusterClientAuthenticationArgs;
 * import com.pulumi.aws.msk.inputs.ClusterClientAuthenticationSaslArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import com.pulumi.aws.secretsmanager.SecretArgs;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import com.pulumi.aws.msk.ScramSecretAssociation;
 * import com.pulumi.aws.msk.ScramSecretAssociationArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.secretsmanager.SecretPolicy;
 * import com.pulumi.aws.secretsmanager.SecretPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCluster = new Cluster("exampleCluster", ClusterArgs.builder()
 *             .clientAuthentication(ClusterClientAuthenticationArgs.builder()
 *                 .sasl(ClusterClientAuthenticationSaslArgs.builder()
 *                     .scram(true)
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("Example Key for MSK Cluster Scram Secret Association")
 *             .build());
 *         var exampleSecret = new Secret("exampleSecret", SecretArgs.builder()
 *             .kmsKeyId(exampleKey.keyId())
 *             .build());
 *         var exampleSecretVersion = new SecretVersion("exampleSecretVersion", SecretVersionArgs.builder()
 *             .secretId(exampleSecret.id())
 *             .secretString(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("username", "user"),
 *                     jsonProperty("password", "pass")
 *                 )))
 *             .build());
 *         var exampleScramSecretAssociation = new ScramSecretAssociation("exampleScramSecretAssociation", ScramSecretAssociationArgs.builder()
 *             .clusterArn(exampleCluster.arn())
 *             .secretArnLists(exampleSecret.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleSecretVersion)
 *                 .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("AWSKafkaResourcePolicy")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("kafka.amazonaws.com")
 *                     .build())
 *                 .actions("secretsmanager:getSecretValue")
 *                 .resources(exampleSecret.arn())
 *                 .build())
 *             .build());
 *         var exampleSecretPolicy = new SecretPolicy("exampleSecretPolicy", SecretPolicyArgs.builder()
 *             .secretArn(exampleSecret.arn())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK SCRAM Secret Associations using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:msk/scramSecretAssociation:ScramSecretAssociation example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 *
 */
public class ScramSecretAssociation internal constructor(
    override val javaResource: com.pulumi.aws.msk.ScramSecretAssociation,
) : KotlinCustomResource(javaResource, ScramSecretAssociationMapper) {
    /**
     * Amazon Resource Name (ARN) of the MSK cluster.
     */
    public val clusterArn: Output<String>
        get() = javaResource.clusterArn().applyValue({ args0 -> args0 })

    /**
     * List of AWS Secrets Manager secret ARNs.
     */
    public val secretArnLists: Output<List<String>>
        get() = javaResource.secretArnLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ScramSecretAssociationMapper : ResourceMapper<ScramSecretAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.msk.ScramSecretAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ScramSecretAssociation =
        ScramSecretAssociation(javaResource as com.pulumi.aws.msk.ScramSecretAssociation)
}

/**
 * @see [ScramSecretAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScramSecretAssociation].
 */
public suspend fun scramSecretAssociation(
    name: String,
    block: suspend ScramSecretAssociationResourceBuilder.() -> Unit,
): ScramSecretAssociation {
    val builder = ScramSecretAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScramSecretAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scramSecretAssociation(name: String): ScramSecretAssociation {
    val builder = ScramSecretAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
