@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.ScramSecretAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Associates SCRAM secrets stored in the Secrets Manager service with a Managed Streaming for Kafka (MSK) cluster.
 * > **Note:** The following assumes the MSK cluster has SASL/SCRAM authentication enabled. See below for example usage or refer to the [Username/Password Authentication](https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html) section of the MSK Developer Guide for more details.
 * To set up username and password authentication for a cluster, create an `aws.secretsmanager.Secret` resource and associate
 * a username and password with the secret with an `aws.secretsmanager.SecretVersion` resource. When creating a secret for the cluster,
 * the `name` must have the prefix `AmazonMSK_` and you must either use an existing custom AWS KMS key or create a new
 * custom AWS KMS key for your secret with the `aws.kms.Key` resource. It is important to note that a policy is required for the `aws.secretsmanager.Secret`
 * resource in order for Kafka to be able to read it. This policy is attached automatically when the `aws.msk.ScramSecretAssociation` is used,
 * however, this policy will not be in the state and as such, will present a diff on plan/apply. For that reason, you must use the `aws.secretsmanager.SecretPolicy`
 * resource](/docs/providers/aws/r/secretsmanager_secret_policy.html) as shown below in order to ensure that the state is in a clean state after the creation of secret and the association to the cluster.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.Cluster;
 * import com.pulumi.aws.msk.ClusterArgs;
 * import com.pulumi.aws.msk.inputs.ClusterClientAuthenticationArgs;
 * import com.pulumi.aws.msk.inputs.ClusterClientAuthenticationSaslArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import com.pulumi.aws.secretsmanager.SecretArgs;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import com.pulumi.aws.msk.ScramSecretAssociation;
 * import com.pulumi.aws.msk.ScramSecretAssociationArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.secretsmanager.SecretPolicy;
 * import com.pulumi.aws.secretsmanager.SecretPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCluster = new Cluster("exampleCluster", ClusterArgs.builder()
 *             .clientAuthentication(ClusterClientAuthenticationArgs.builder()
 *                 .sasl(ClusterClientAuthenticationSaslArgs.builder()
 *                     .scram(true)
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("Example Key for MSK Cluster Scram Secret Association")
 *             .build());
 *         var exampleSecret = new Secret("exampleSecret", SecretArgs.builder()
 *             .kmsKeyId(exampleKey.keyId())
 *             .build());
 *         var exampleSecretVersion = new SecretVersion("exampleSecretVersion", SecretVersionArgs.builder()
 *             .secretId(exampleSecret.id())
 *             .secretString(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("username", "user"),
 *                     jsonProperty("password", "pass")
 *                 )))
 *             .build());
 *         var exampleScramSecretAssociation = new ScramSecretAssociation("exampleScramSecretAssociation", ScramSecretAssociationArgs.builder()
 *             .clusterArn(exampleCluster.arn())
 *             .secretArnLists(exampleSecret.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleSecretVersion)
 *                 .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("AWSKafkaResourcePolicy")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("kafka.amazonaws.com")
 *                     .build())
 *                 .actions("secretsmanager:getSecretValue")
 *                 .resources(exampleSecret.arn())
 *                 .build())
 *             .build());
 *         var exampleSecretPolicy = new SecretPolicy("exampleSecretPolicy", SecretPolicyArgs.builder()
 *             .secretArn(exampleSecret.arn())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK SCRAM Secret Associations using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:msk/scramSecretAssociation:ScramSecretAssociation example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 * @property clusterArn Amazon Resource Name (ARN) of the MSK cluster.
 * @property secretArnLists List of AWS Secrets Manager secret ARNs.
 */
public data class ScramSecretAssociationArgs(
    public val clusterArn: Output<String>? = null,
    public val secretArnLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.ScramSecretAssociationArgs> {
    override fun toJava(): com.pulumi.aws.msk.ScramSecretAssociationArgs =
        com.pulumi.aws.msk.ScramSecretAssociationArgs.builder()
            .clusterArn(clusterArn?.applyValue({ args0 -> args0 }))
            .secretArnLists(secretArnLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ScramSecretAssociationArgs].
 */
@PulumiTagMarker
public class ScramSecretAssociationArgsBuilder internal constructor() {
    private var clusterArn: Output<String>? = null

    private var secretArnLists: Output<List<String>>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the MSK cluster.
     */
    @JvmName("kswlruolpfqrrslv")
    public suspend fun clusterArn(`value`: Output<String>) {
        this.clusterArn = value
    }

    /**
     * @param value List of AWS Secrets Manager secret ARNs.
     */
    @JvmName("rushowjgljddaakc")
    public suspend fun secretArnLists(`value`: Output<List<String>>) {
        this.secretArnLists = value
    }

    @JvmName("bhjycbwfxehlblue")
    public suspend fun secretArnLists(vararg values: Output<String>) {
        this.secretArnLists = Output.all(values.asList())
    }

    /**
     * @param values List of AWS Secrets Manager secret ARNs.
     */
    @JvmName("pxfkyssdoutpcdct")
    public suspend fun secretArnLists(values: List<Output<String>>) {
        this.secretArnLists = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the MSK cluster.
     */
    @JvmName("cvfpcsiysxvyeelw")
    public suspend fun clusterArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterArn = mapped
    }

    /**
     * @param value List of AWS Secrets Manager secret ARNs.
     */
    @JvmName("lqkcjqgtgfkeuhkx")
    public suspend fun secretArnLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretArnLists = mapped
    }

    /**
     * @param values List of AWS Secrets Manager secret ARNs.
     */
    @JvmName("ropmpkeovfhepdsr")
    public suspend fun secretArnLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretArnLists = mapped
    }

    internal fun build(): ScramSecretAssociationArgs = ScramSecretAssociationArgs(
        clusterArn = clusterArn,
        secretArnLists = secretArnLists,
    )
}
