@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.kotlin.outputs.ServerlessClusterClientAuthentication
import com.pulumi.aws.msk.kotlin.outputs.ServerlessClusterVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.msk.kotlin.outputs.ServerlessClusterClientAuthentication.Companion.toKotlin as serverlessClusterClientAuthenticationToKotlin
import com.pulumi.aws.msk.kotlin.outputs.ServerlessClusterVpcConfig.Companion.toKotlin as serverlessClusterVpcConfigToKotlin

/**
 * Builder for [ServerlessCluster].
 */
@PulumiTagMarker
public class ServerlessClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerlessClusterArgs = ServerlessClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerlessClusterArgsBuilder.() -> Unit) {
        val builder = ServerlessClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServerlessCluster {
        val builtJavaResource = com.pulumi.aws.msk.ServerlessCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerlessCluster(builtJavaResource)
    }
}

/**
 * Manages an Amazon MSK Serverless cluster.
 * > **Note:** To manage a _provisioned_ Amazon MSK cluster, use the `aws.msk.Cluster` resource.
 * ## Import
 * Using `pulumi import`, import MSK serverless clusters using the cluster `arn`. For example:
 * ```sh
 *  $ pulumi import aws:msk/serverlessCluster:ServerlessCluster example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 *
 */
public class ServerlessCluster internal constructor(
    override val javaResource: com.pulumi.aws.msk.ServerlessCluster,
) : KotlinCustomResource(javaResource, ServerlessClusterMapper) {
    /**
     * The ARN of the serverless cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies client authentication information for the serverless cluster. See below.
     */
    public val clientAuthentication: Output<ServerlessClusterClientAuthentication>
        get() = javaResource.clientAuthentication().applyValue({ args0 ->
            args0.let({ args0 ->
                serverlessClusterClientAuthenticationToKotlin(args0)
            })
        })

    /**
     * The name of the serverless cluster.
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * UUID of the serverless cluster, for use in IAM policies.
     */
    public val clusterUuid: Output<String>
        get() = javaResource.clusterUuid().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * VPC configuration information. See below.
     */
    public val vpcConfigs: Output<List<ServerlessClusterVpcConfig>>
        get() = javaResource.vpcConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serverlessClusterVpcConfigToKotlin(args0)
                })
            })
        })
}

public object ServerlessClusterMapper : ResourceMapper<ServerlessCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.msk.ServerlessCluster::class == javaResource::class

    override fun map(javaResource: Resource): ServerlessCluster = ServerlessCluster(
        javaResource as
            com.pulumi.aws.msk.ServerlessCluster,
    )
}

/**
 * @see [ServerlessCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerlessCluster].
 */
public suspend fun serverlessCluster(
    name: String,
    block: suspend ServerlessClusterResourceBuilder.() -> Unit,
): ServerlessCluster {
    val builder = ServerlessClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerlessCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverlessCluster(name: String): ServerlessCluster {
    val builder = ServerlessClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
