@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.ServerlessClusterArgs.builder
import com.pulumi.aws.msk.kotlin.inputs.ServerlessClusterClientAuthenticationArgs
import com.pulumi.aws.msk.kotlin.inputs.ServerlessClusterClientAuthenticationArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.ServerlessClusterVpcConfigArgs
import com.pulumi.aws.msk.kotlin.inputs.ServerlessClusterVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon MSK Serverless cluster.
 * > **Note:** To manage a _provisioned_ Amazon MSK cluster, use the `aws.msk.Cluster` resource.
 * ## Import
 * Using `pulumi import`, import MSK serverless clusters using the cluster `arn`. For example:
 * ```sh
 *  $ pulumi import aws:msk/serverlessCluster:ServerlessCluster example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 * @property clientAuthentication Specifies client authentication information for the serverless cluster. See below.
 * @property clusterName The name of the serverless cluster.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcConfigs VPC configuration information. See below.
 */
public data class ServerlessClusterArgs(
    public val clientAuthentication: Output<ServerlessClusterClientAuthenticationArgs>? = null,
    public val clusterName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfigs: Output<List<ServerlessClusterVpcConfigArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.ServerlessClusterArgs> {
    override fun toJava(): com.pulumi.aws.msk.ServerlessClusterArgs =
        com.pulumi.aws.msk.ServerlessClusterArgs.builder()
            .clientAuthentication(
                clientAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfigs(
                vpcConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServerlessClusterArgs].
 */
@PulumiTagMarker
public class ServerlessClusterArgsBuilder internal constructor() {
    private var clientAuthentication: Output<ServerlessClusterClientAuthenticationArgs>? = null

    private var clusterName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfigs: Output<List<ServerlessClusterVpcConfigArgs>>? = null

    /**
     * @param value Specifies client authentication information for the serverless cluster. See below.
     */
    @JvmName("hxdqoigmndpssifv")
    public suspend
    fun clientAuthentication(`value`: Output<ServerlessClusterClientAuthenticationArgs>) {
        this.clientAuthentication = value
    }

    /**
     * @param value The name of the serverless cluster.
     */
    @JvmName("yjfykmwuovvhpjru")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("srxgmenvcradvtgs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VPC configuration information. See below.
     */
    @JvmName("vctqrpmuxfrbdrhy")
    public suspend fun vpcConfigs(`value`: Output<List<ServerlessClusterVpcConfigArgs>>) {
        this.vpcConfigs = value
    }

    @JvmName("ulbgfcyfysqtcfvv")
    public suspend fun vpcConfigs(vararg values: Output<ServerlessClusterVpcConfigArgs>) {
        this.vpcConfigs = Output.all(values.asList())
    }

    /**
     * @param values VPC configuration information. See below.
     */
    @JvmName("flnuurgokmfhgdqg")
    public suspend fun vpcConfigs(values: List<Output<ServerlessClusterVpcConfigArgs>>) {
        this.vpcConfigs = Output.all(values)
    }

    /**
     * @param value Specifies client authentication information for the serverless cluster. See below.
     */
    @JvmName("vixsmedxalkutxwl")
    public suspend fun clientAuthentication(`value`: ServerlessClusterClientAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAuthentication = mapped
    }

    /**
     * @param argument Specifies client authentication information for the serverless cluster. See below.
     */
    @JvmName("gvlocbcvderdtcog")
    public suspend
    fun clientAuthentication(argument: suspend ServerlessClusterClientAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessClusterClientAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.clientAuthentication = mapped
    }

    /**
     * @param value The name of the serverless cluster.
     */
    @JvmName("oupgqcraotxkkvbd")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("okwfqqufiqqvlcol")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cdoikaiydfppltfw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VPC configuration information. See below.
     */
    @JvmName("sdasotclwlhlkqyk")
    public suspend fun vpcConfigs(`value`: List<ServerlessClusterVpcConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfigs = mapped
    }

    /**
     * @param argument VPC configuration information. See below.
     */
    @JvmName("ougqvuujytcjdiui")
    public suspend
    fun vpcConfigs(argument: List<suspend ServerlessClusterVpcConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServerlessClusterVpcConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpcConfigs = mapped
    }

    /**
     * @param argument VPC configuration information. See below.
     */
    @JvmName("pducbtkwhbbwcejt")
    public suspend fun vpcConfigs(
        vararg
        argument: suspend ServerlessClusterVpcConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServerlessClusterVpcConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpcConfigs = mapped
    }

    /**
     * @param argument VPC configuration information. See below.
     */
    @JvmName("pwnwfwyywuypmioa")
    public suspend
    fun vpcConfigs(argument: suspend ServerlessClusterVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServerlessClusterVpcConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpcConfigs = mapped
    }

    /**
     * @param values VPC configuration information. See below.
     */
    @JvmName("vnocnusmujbemrne")
    public suspend fun vpcConfigs(vararg values: ServerlessClusterVpcConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcConfigs = mapped
    }

    internal fun build(): ServerlessClusterArgs = ServerlessClusterArgs(
        clientAuthentication = clientAuthentication,
        clusterName = clusterName,
        tags = tags,
        vpcConfigs = vpcConfigs,
    )
}
