@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.VpcConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Managed Streaming for Kafka VPC Connection.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.VpcConnection;
 * import com.pulumi.aws.msk.VpcConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new VpcConnection("test", VpcConnectionArgs.builder()
 *             .authentication("SASL_IAM")
 *             .targetClusterArn("aws_msk_cluster.arn")
 *             .vpcId(aws_vpc.test().id())
 *             .clientSubnets(aws_subnet.test().stream().map(element -> element.id()).collect(toList()))
 *             .securityGroups(aws_security_group.test().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK configurations using the configuration ARN. For example:
 * ```sh
 *  $ pulumi import aws:msk/vpcConnection:VpcConnection example arn:aws:kafka:eu-west-2:123456789012:vpc-connection/123456789012/example/38173259-79cd-4ee8-87f3-682ea6023f48-2
 * ```
 * @property authentication The authentication type for the client VPC connection. Specify one of these auth type strings: SASL_IAM, SASL_SCRAM, or TLS.
 * @property clientSubnets The list of subnets in the client VPC to connect to.
 * @property securityGroups The security groups to attach to the ENIs for the broker nodes.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetClusterArn The Amazon Resource Name (ARN) of the cluster.
 * @property vpcId The VPC ID of the remote client.
 */
public data class VpcConnectionArgs(
    public val authentication: Output<String>? = null,
    public val clientSubnets: Output<List<String>>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetClusterArn: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.VpcConnectionArgs> {
    override fun toJava(): com.pulumi.aws.msk.VpcConnectionArgs =
        com.pulumi.aws.msk.VpcConnectionArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .clientSubnets(clientSubnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetClusterArn(targetClusterArn?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcConnectionArgs].
 */
@PulumiTagMarker
public class VpcConnectionArgsBuilder internal constructor() {
    private var authentication: Output<String>? = null

    private var clientSubnets: Output<List<String>>? = null

    private var securityGroups: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetClusterArn: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The authentication type for the client VPC connection. Specify one of these auth type strings: SASL_IAM, SASL_SCRAM, or TLS.
     */
    @JvmName("hfilfmcmswqhbssm")
    public suspend fun authentication(`value`: Output<String>) {
        this.authentication = value
    }

    /**
     * @param value The list of subnets in the client VPC to connect to.
     */
    @JvmName("nwmtcgubesymplsc")
    public suspend fun clientSubnets(`value`: Output<List<String>>) {
        this.clientSubnets = value
    }

    @JvmName("mjgtpmnkyvmxgdhf")
    public suspend fun clientSubnets(vararg values: Output<String>) {
        this.clientSubnets = Output.all(values.asList())
    }

    /**
     * @param values The list of subnets in the client VPC to connect to.
     */
    @JvmName("ctfgvsljuyelxfxv")
    public suspend fun clientSubnets(values: List<Output<String>>) {
        this.clientSubnets = Output.all(values)
    }

    /**
     * @param value The security groups to attach to the ENIs for the broker nodes.
     */
    @JvmName("cfpxaycanntbxecu")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("cwboeglnyuycrqnn")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values The security groups to attach to the ENIs for the broker nodes.
     */
    @JvmName("dghyjggawffepxml")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("geafgilsqorkhmsy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the cluster.
     */
    @JvmName("rbyrnkmcfttcigox")
    public suspend fun targetClusterArn(`value`: Output<String>) {
        this.targetClusterArn = value
    }

    /**
     * @param value The VPC ID of the remote client.
     */
    @JvmName("cavbkjrcxbbbryte")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The authentication type for the client VPC connection. Specify one of these auth type strings: SASL_IAM, SASL_SCRAM, or TLS.
     */
    @JvmName("eooivhflxktjtgxr")
    public suspend fun authentication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value The list of subnets in the client VPC to connect to.
     */
    @JvmName("kutyrsvawbfnfywm")
    public suspend fun clientSubnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSubnets = mapped
    }

    /**
     * @param values The list of subnets in the client VPC to connect to.
     */
    @JvmName("cljgfkgbnqlavgcw")
    public suspend fun clientSubnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSubnets = mapped
    }

    /**
     * @param value The security groups to attach to the ENIs for the broker nodes.
     */
    @JvmName("kssmaivbrhvrpalc")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values The security groups to attach to the ENIs for the broker nodes.
     */
    @JvmName("clsvpgsbonurxccx")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("groiykfjsjuklgqt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("edxaefryqeomtvxe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the cluster.
     */
    @JvmName("uxwxwkgsjustkskd")
    public suspend fun targetClusterArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetClusterArn = mapped
    }

    /**
     * @param value The VPC ID of the remote client.
     */
    @JvmName("hrswsicudakjvgsk")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): VpcConnectionArgs = VpcConnectionArgs(
        authentication = authentication,
        clientSubnets = clientSubnets,
        securityGroups = securityGroups,
        tags = tags,
        targetClusterArn = targetClusterArn,
        vpcId = vpcId,
    )
}
