@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Public access type. Valid values: `DISABLED`, `SERVICE_PROVIDED_EIPS`.
 */
public data class ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs(
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs> {
    override fun toJava():
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs =
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs.builder()
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs].
 */
@PulumiTagMarker
public class ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgsBuilder internal
constructor() {
    private var type: Output<String>? = null

    /**
     * @param value Public access type. Valid values: `DISABLED`, `SERVICE_PROVIDED_EIPS`.
     */
    @JvmName("mcddrkbldypdesbw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Public access type. Valid values: `DISABLED`, `SERVICE_PROVIDED_EIPS`.
     */
    @JvmName("mfldkfucupngyiyi")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs =
        ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs(
            type = type,
        )
}
