@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property iam Enables IAM client authentication. Defaults to `false`.
 * @property scram Enables SCRAM client authentication via AWS Secrets Manager. Defaults to `false`.
 */
public data class
ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs(
    public val iam: Output<Boolean>? = null,
    public val scram: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs> {
    override fun toJava():
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs =
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs.builder()
            .iam(iam?.applyValue({ args0 -> args0 }))
            .scram(scram?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs].
 */
@PulumiTagMarker
public class
ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgsBuilder
internal constructor() {
    private var iam: Output<Boolean>? = null

    private var scram: Output<Boolean>? = null

    /**
     * @param value Enables IAM client authentication. Defaults to `false`.
     */
    @JvmName("kqeyfpcaonrdcqqu")
    public suspend fun iam(`value`: Output<Boolean>) {
        this.iam = value
    }

    /**
     * @param value Enables SCRAM client authentication via AWS Secrets Manager. Defaults to `false`.
     */
    @JvmName("tydbvcxnkprpftmq")
    public suspend fun scram(`value`: Output<Boolean>) {
        this.scram = value
    }

    /**
     * @param value Enables IAM client authentication. Defaults to `false`.
     */
    @JvmName("rlhtshtnqbisqdpq")
    public suspend fun iam(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iam = mapped
    }

    /**
     * @param value Enables SCRAM client authentication via AWS Secrets Manager. Defaults to `false`.
     */
    @JvmName("caocimmxcogprwmk")
    public suspend fun scram(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scram = mapped
    }

    internal fun build():
        ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs =
        ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs(
            iam = iam,
            scram = scram,
        )
}
