@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterClientAuthenticationTlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certificateAuthorityArns List of ACM Certificate Authority Amazon Resource Names (ARNs).
 */
public data class ClusterClientAuthenticationTlsArgs(
    public val certificateAuthorityArns: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterClientAuthenticationTlsArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterClientAuthenticationTlsArgs =
        com.pulumi.aws.msk.inputs.ClusterClientAuthenticationTlsArgs.builder()
            .certificateAuthorityArns(
                certificateAuthorityArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterClientAuthenticationTlsArgs].
 */
@PulumiTagMarker
public class ClusterClientAuthenticationTlsArgsBuilder internal constructor() {
    private var certificateAuthorityArns: Output<List<String>>? = null

    /**
     * @param value List of ACM Certificate Authority Amazon Resource Names (ARNs).
     */
    @JvmName("gwbciabfmuhcfsbh")
    public suspend fun certificateAuthorityArns(`value`: Output<List<String>>) {
        this.certificateAuthorityArns = value
    }

    @JvmName("kklrmfoloioxrupl")
    public suspend fun certificateAuthorityArns(vararg values: Output<String>) {
        this.certificateAuthorityArns = Output.all(values.asList())
    }

    /**
     * @param values List of ACM Certificate Authority Amazon Resource Names (ARNs).
     */
    @JvmName("lmrkdwuxebufljkj")
    public suspend fun certificateAuthorityArns(values: List<Output<String>>) {
        this.certificateAuthorityArns = Output.all(values)
    }

    /**
     * @param value List of ACM Certificate Authority Amazon Resource Names (ARNs).
     */
    @JvmName("dnckxcqijkygatyf")
    public suspend fun certificateAuthorityArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateAuthorityArns = mapped
    }

    /**
     * @param values List of ACM Certificate Authority Amazon Resource Names (ARNs).
     */
    @JvmName("kcwgaitcgwpnrusp")
    public suspend fun certificateAuthorityArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateAuthorityArns = mapped
    }

    internal fun build(): ClusterClientAuthenticationTlsArgs = ClusterClientAuthenticationTlsArgs(
        certificateAuthorityArns = certificateAuthorityArns,
    )
}
