@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterConfigurationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
 * @property revision Revision of the MSK Configuration to use in the cluster.
 */
public data class ClusterConfigurationInfoArgs(
    public val arn: Output<String>,
    public val revision: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterConfigurationInfoArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterConfigurationInfoArgs =
        com.pulumi.aws.msk.inputs.ClusterConfigurationInfoArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .revision(revision.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterConfigurationInfoArgs].
 */
@PulumiTagMarker
public class ClusterConfigurationInfoArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var revision: Output<Int>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
     */
    @JvmName("kgkuxybwemoevnfw")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Revision of the MSK Configuration to use in the cluster.
     */
    @JvmName("wpuylqnqrquwalix")
    public suspend fun revision(`value`: Output<Int>) {
        this.revision = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
     */
    @JvmName("tokbpbmqhihfgdhl")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Revision of the MSK Configuration to use in the cluster.
     */
    @JvmName("eoluabmmsahdiygh")
    public suspend fun revision(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    internal fun build(): ClusterConfigurationInfoArgs = ClusterConfigurationInfoArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        revision = revision ?: throw PulumiNullFieldException("revision"),
    )
}
