@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterEncryptionInfoEncryptionInTransitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientBroker Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`. Default value is `TLS`.
 * @property inCluster Whether data communication among broker nodes is encrypted. Default value: `true`.
 */
public data class ClusterEncryptionInfoEncryptionInTransitArgs(
    public val clientBroker: Output<String>? = null,
    public val inCluster: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterEncryptionInfoEncryptionInTransitArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterEncryptionInfoEncryptionInTransitArgs =
        com.pulumi.aws.msk.inputs.ClusterEncryptionInfoEncryptionInTransitArgs.builder()
            .clientBroker(clientBroker?.applyValue({ args0 -> args0 }))
            .inCluster(inCluster?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterEncryptionInfoEncryptionInTransitArgs].
 */
@PulumiTagMarker
public class ClusterEncryptionInfoEncryptionInTransitArgsBuilder internal constructor() {
    private var clientBroker: Output<String>? = null

    private var inCluster: Output<Boolean>? = null

    /**
     * @param value Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`. Default value is `TLS`.
     */
    @JvmName("cdobxelmpcjxones")
    public suspend fun clientBroker(`value`: Output<String>) {
        this.clientBroker = value
    }

    /**
     * @param value Whether data communication among broker nodes is encrypted. Default value: `true`.
     */
    @JvmName("mmgnmmsrlxyokqos")
    public suspend fun inCluster(`value`: Output<Boolean>) {
        this.inCluster = value
    }

    /**
     * @param value Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`. Default value is `TLS`.
     */
    @JvmName("crkgstyiyrekiegu")
    public suspend fun clientBroker(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientBroker = mapped
    }

    /**
     * @param value Whether data communication among broker nodes is encrypted. Default value: `true`.
     */
    @JvmName("ehihpiaqighlbvcb")
    public suspend fun inCluster(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inCluster = mapped
    }

    internal fun build(): ClusterEncryptionInfoEncryptionInTransitArgs =
        ClusterEncryptionInfoEncryptionInTransitArgs(
            clientBroker = clientBroker,
            inCluster = inCluster,
        )
}
