@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogs
 * @property firehose
 * @property s3
 */
public data class ClusterLoggingInfoBrokerLogsArgs(
    public val cloudwatchLogs: Output<ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs>? = null,
    public val firehose: Output<ClusterLoggingInfoBrokerLogsFirehoseArgs>? = null,
    public val s3: Output<ClusterLoggingInfoBrokerLogsS3Args>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsArgs =
        com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsArgs.builder()
            .cloudwatchLogs(cloudwatchLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firehose(firehose?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3(s3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClusterLoggingInfoBrokerLogsArgs].
 */
@PulumiTagMarker
public class ClusterLoggingInfoBrokerLogsArgsBuilder internal constructor() {
    private var cloudwatchLogs: Output<ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs>? = null

    private var firehose: Output<ClusterLoggingInfoBrokerLogsFirehoseArgs>? = null

    private var s3: Output<ClusterLoggingInfoBrokerLogsS3Args>? = null

    /**
     * @param value
     */
    @JvmName("ayxmwctkhmpkngav")
    public suspend
    fun cloudwatchLogs(`value`: Output<ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs>) {
        this.cloudwatchLogs = value
    }

    /**
     * @param value
     */
    @JvmName("hmbfnwovlmaolmrg")
    public suspend fun firehose(`value`: Output<ClusterLoggingInfoBrokerLogsFirehoseArgs>) {
        this.firehose = value
    }

    /**
     * @param value
     */
    @JvmName("jiubnquriwrrqujv")
    public suspend fun s3(`value`: Output<ClusterLoggingInfoBrokerLogsS3Args>) {
        this.s3 = value
    }

    /**
     * @param value
     */
    @JvmName("pmuawowrdhvghlcd")
    public suspend fun cloudwatchLogs(`value`: ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ouieyihdlmjuneyy")
    public suspend
    fun cloudwatchLogs(argument: suspend ClusterLoggingInfoBrokerLogsCloudwatchLogsArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterLoggingInfoBrokerLogsCloudwatchLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param value
     */
    @JvmName("gbkhuuyoieoivdit")
    public suspend fun firehose(`value`: ClusterLoggingInfoBrokerLogsFirehoseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehose = mapped
    }

    /**
     * @param argument
     */
    @JvmName("upbkadkbbunuefgg")
    public suspend
    fun firehose(argument: suspend ClusterLoggingInfoBrokerLogsFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterLoggingInfoBrokerLogsFirehoseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.firehose = mapped
    }

    /**
     * @param value
     */
    @JvmName("forifjmgnqrmhdjc")
    public suspend fun s3(`value`: ClusterLoggingInfoBrokerLogsS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aepswbnoiymqxwfy")
    public suspend fun s3(argument: suspend ClusterLoggingInfoBrokerLogsS3ArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterLoggingInfoBrokerLogsS3ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    internal fun build(): ClusterLoggingInfoBrokerLogsArgs = ClusterLoggingInfoBrokerLogsArgs(
        cloudwatchLogs = cloudwatchLogs,
        firehose = firehose,
        s3 = s3,
    )
}
