@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Controls whether provisioned throughput is enabled or not. Default value: `false`.
 * @property logGroup Name of the Cloudwatch Log Group to deliver logs to.
 */
public data class ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs(
    public val enabled: Output<Boolean>,
    public val logGroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs =
        com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .logGroup(logGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs].
 */
@PulumiTagMarker
public class ClusterLoggingInfoBrokerLogsCloudwatchLogsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logGroup: Output<String>? = null

    /**
     * @param value Controls whether provisioned throughput is enabled or not. Default value: `false`.
     */
    @JvmName("sdneccxyoofqypfr")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Name of the Cloudwatch Log Group to deliver logs to.
     */
    @JvmName("ayckgmnkuxpplteq")
    public suspend fun logGroup(`value`: Output<String>) {
        this.logGroup = value
    }

    /**
     * @param value Controls whether provisioned throughput is enabled or not. Default value: `false`.
     */
    @JvmName("cythrthbtlvlverw")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Name of the Cloudwatch Log Group to deliver logs to.
     */
    @JvmName("qofchckqxvtyfjhh")
    public suspend fun logGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroup = mapped
    }

    internal fun build(): ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs =
        ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            logGroup = logGroup,
        )
}
