@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket Name of the S3 bucket to deliver logs to.
 * @property enabled Controls whether provisioned throughput is enabled or not. Default value: `false`.
 * @property prefix Prefix to append to the folder name.
 */
public data class ClusterLoggingInfoBrokerLogsS3Args(
    public val bucket: Output<String>? = null,
    public val enabled: Output<Boolean>,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsS3Args> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsS3Args =
        com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsS3Args.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterLoggingInfoBrokerLogsS3Args].
 */
@PulumiTagMarker
public class ClusterLoggingInfoBrokerLogsS3ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value Name of the S3 bucket to deliver logs to.
     */
    @JvmName("fjjuhoxrdlqxopca")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Controls whether provisioned throughput is enabled or not. Default value: `false`.
     */
    @JvmName("rxibhdwvxhgbocud")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Prefix to append to the folder name.
     */
    @JvmName("dbvpnbbtkkonsisx")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Name of the S3 bucket to deliver logs to.
     */
    @JvmName("rucofaaxlboxugqx")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Controls whether provisioned throughput is enabled or not. Default value: `false`.
     */
    @JvmName("xnbhxkabaeitrbpe")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Prefix to append to the folder name.
     */
    @JvmName("gnmfxkdloadxhmhy")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): ClusterLoggingInfoBrokerLogsS3Args = ClusterLoggingInfoBrokerLogsS3Args(
        bucket = bucket,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        prefix = prefix,
    )
}
