@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property prometheus Configuration block for Prometheus settings for open monitoring. See below.
 */
public data class ClusterOpenMonitoringArgs(
    public val prometheus: Output<ClusterOpenMonitoringPrometheusArgs>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterOpenMonitoringArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterOpenMonitoringArgs =
        com.pulumi.aws.msk.inputs.ClusterOpenMonitoringArgs.builder()
            .prometheus(prometheus.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClusterOpenMonitoringArgs].
 */
@PulumiTagMarker
public class ClusterOpenMonitoringArgsBuilder internal constructor() {
    private var prometheus: Output<ClusterOpenMonitoringPrometheusArgs>? = null

    /**
     * @param value Configuration block for Prometheus settings for open monitoring. See below.
     */
    @JvmName("ehogngefovhgpabb")
    public suspend fun prometheus(`value`: Output<ClusterOpenMonitoringPrometheusArgs>) {
        this.prometheus = value
    }

    /**
     * @param value Configuration block for Prometheus settings for open monitoring. See below.
     */
    @JvmName("rtlryaoiwmmbpeib")
    public suspend fun prometheus(`value`: ClusterOpenMonitoringPrometheusArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prometheus = mapped
    }

    /**
     * @param argument Configuration block for Prometheus settings for open monitoring. See below.
     */
    @JvmName("gpuqpejapjgveyno")
    public suspend
    fun prometheus(argument: suspend ClusterOpenMonitoringPrometheusArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterOpenMonitoringPrometheusArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.prometheus = mapped
    }

    internal fun build(): ClusterOpenMonitoringArgs = ClusterOpenMonitoringArgs(
        prometheus = prometheus ?: throw PulumiNullFieldException("prometheus"),
    )
}
