@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property jmxExporter Configuration block for JMX Exporter. See below.
 * @property nodeExporter Configuration block for Node Exporter. See below.
 */
public data class ClusterOpenMonitoringPrometheusArgs(
    public val jmxExporter: Output<ClusterOpenMonitoringPrometheusJmxExporterArgs>? = null,
    public val nodeExporter: Output<ClusterOpenMonitoringPrometheusNodeExporterArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusArgs =
        com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusArgs.builder()
            .jmxExporter(jmxExporter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nodeExporter(nodeExporter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClusterOpenMonitoringPrometheusArgs].
 */
@PulumiTagMarker
public class ClusterOpenMonitoringPrometheusArgsBuilder internal constructor() {
    private var jmxExporter: Output<ClusterOpenMonitoringPrometheusJmxExporterArgs>? = null

    private var nodeExporter: Output<ClusterOpenMonitoringPrometheusNodeExporterArgs>? = null

    /**
     * @param value Configuration block for JMX Exporter. See below.
     */
    @JvmName("gvgjtrafcpcsrjby")
    public suspend fun jmxExporter(`value`: Output<ClusterOpenMonitoringPrometheusJmxExporterArgs>) {
        this.jmxExporter = value
    }

    /**
     * @param value Configuration block for Node Exporter. See below.
     */
    @JvmName("rnhngptaapjturae")
    public suspend
    fun nodeExporter(`value`: Output<ClusterOpenMonitoringPrometheusNodeExporterArgs>) {
        this.nodeExporter = value
    }

    /**
     * @param value Configuration block for JMX Exporter. See below.
     */
    @JvmName("cfafmgodfwehocbp")
    public suspend fun jmxExporter(`value`: ClusterOpenMonitoringPrometheusJmxExporterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jmxExporter = mapped
    }

    /**
     * @param argument Configuration block for JMX Exporter. See below.
     */
    @JvmName("pkqcmndpjotrrgjo")
    public suspend
    fun jmxExporter(argument: suspend ClusterOpenMonitoringPrometheusJmxExporterArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterOpenMonitoringPrometheusJmxExporterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jmxExporter = mapped
    }

    /**
     * @param value Configuration block for Node Exporter. See below.
     */
    @JvmName("aiydghucctwljkpf")
    public suspend fun nodeExporter(`value`: ClusterOpenMonitoringPrometheusNodeExporterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeExporter = mapped
    }

    /**
     * @param argument Configuration block for Node Exporter. See below.
     */
    @JvmName("urlmoioaqcteeofh")
    public suspend
    fun nodeExporter(argument: suspend ClusterOpenMonitoringPrometheusNodeExporterArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterOpenMonitoringPrometheusNodeExporterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nodeExporter = mapped
    }

    internal fun build(): ClusterOpenMonitoringPrometheusArgs = ClusterOpenMonitoringPrometheusArgs(
        jmxExporter = jmxExporter,
        nodeExporter = nodeExporter,
    )
}
