@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusNodeExporterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabledInBroker Indicates whether you want to enable or disable the Node Exporter.
 */
public data class ClusterOpenMonitoringPrometheusNodeExporterArgs(
    public val enabledInBroker: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusNodeExporterArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusNodeExporterArgs =
        com.pulumi.aws.msk.inputs.ClusterOpenMonitoringPrometheusNodeExporterArgs.builder()
            .enabledInBroker(enabledInBroker.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterOpenMonitoringPrometheusNodeExporterArgs].
 */
@PulumiTagMarker
public class ClusterOpenMonitoringPrometheusNodeExporterArgsBuilder internal constructor() {
    private var enabledInBroker: Output<Boolean>? = null

    /**
     * @param value Indicates whether you want to enable or disable the Node Exporter.
     */
    @JvmName("pqvktehhaonorhqb")
    public suspend fun enabledInBroker(`value`: Output<Boolean>) {
        this.enabledInBroker = value
    }

    /**
     * @param value Indicates whether you want to enable or disable the Node Exporter.
     */
    @JvmName("olbsbbgnwclkdojl")
    public suspend fun enabledInBroker(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledInBroker = mapped
    }

    internal fun build(): ClusterOpenMonitoringPrometheusNodeExporterArgs =
        ClusterOpenMonitoringPrometheusNodeExporterArgs(
            enabledInBroker = enabledInBroker ?: throw PulumiNullFieldException("enabledInBroker"),
        )
}
