@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.GetBrokerNodesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBrokerNodes.
 * @property clusterArn ARN of the cluster the nodes belong to.
 */
public data class GetBrokerNodesPlainArgs(
    public val clusterArn: String,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.GetBrokerNodesPlainArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.GetBrokerNodesPlainArgs =
        com.pulumi.aws.msk.inputs.GetBrokerNodesPlainArgs.builder()
            .clusterArn(clusterArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBrokerNodesPlainArgs].
 */
@PulumiTagMarker
public class GetBrokerNodesPlainArgsBuilder internal constructor() {
    private var clusterArn: String? = null

    /**
     * @param value ARN of the cluster the nodes belong to.
     */
    @JvmName("sjvaesdqetuuomxn")
    public suspend fun clusterArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterArn = mapped
    }

    internal fun build(): GetBrokerNodesPlainArgs = GetBrokerNodesPlainArgs(
        clusterArn = clusterArn ?: throw PulumiNullFieldException("clusterArn"),
    )
}
