@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.GetConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConfiguration.
 * @property name Name of the configuration.
 */
public data class GetConfigurationPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.GetConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.GetConfigurationPlainArgs =
        com.pulumi.aws.msk.inputs.GetConfigurationPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the configuration.
     */
    @JvmName("knitgoxkcpyfljkk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetConfigurationPlainArgs = GetConfigurationPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
