@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.GetVpcConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcConnection.
 * @property arn ARN of the VPC Connection.
 * @property tags Map of key-value pairs assigned to the VPC Connection.
 */
public data class GetVpcConnectionPlainArgs(
    public val arn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.GetVpcConnectionPlainArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.GetVpcConnectionPlainArgs =
        com.pulumi.aws.msk.inputs.GetVpcConnectionPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVpcConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetVpcConnectionPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the VPC Connection.
     */
    @JvmName("kshrstuuecubgsei")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Map of key-value pairs assigned to the VPC Connection.
     */
    @JvmName("filnjxtpuvhddvcr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of key-value pairs assigned to the VPC Connection.
     */
    @JvmName("jikwsoteewkrqhxo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVpcConnectionPlainArgs = GetVpcConnectionPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        tags = tags,
    )
}
