@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterAmazonMskClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mskClusterArn The ARN of an Amazon MSK cluster.
 */
public data class ReplicatorKafkaClusterAmazonMskClusterArgs(
    public val mskClusterArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterAmazonMskClusterArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterAmazonMskClusterArgs =
        com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterAmazonMskClusterArgs.builder()
            .mskClusterArn(mskClusterArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicatorKafkaClusterAmazonMskClusterArgs].
 */
@PulumiTagMarker
public class ReplicatorKafkaClusterAmazonMskClusterArgsBuilder internal constructor() {
    private var mskClusterArn: Output<String>? = null

    /**
     * @param value The ARN of an Amazon MSK cluster.
     */
    @JvmName("gnnohlrmibvftmea")
    public suspend fun mskClusterArn(`value`: Output<String>) {
        this.mskClusterArn = value
    }

    /**
     * @param value The ARN of an Amazon MSK cluster.
     */
    @JvmName("tvincgtfyxohgjri")
    public suspend fun mskClusterArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mskClusterArn = mapped
    }

    internal fun build(): ReplicatorKafkaClusterAmazonMskClusterArgs =
        ReplicatorKafkaClusterAmazonMskClusterArgs(
            mskClusterArn = mskClusterArn ?: throw PulumiNullFieldException("mskClusterArn"),
        )
}
