@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property copyAccessControlListsForTopics Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
 * @property copyTopicConfigurations Whether to periodically configure remote topics to match their corresponding upstream topics.
 * @property detectAndCopyNewTopics Whether to periodically check for new topics and partitions.
 * @property topicsToExcludes List of regular expression patterns indicating the topics that should not be replica.
 * @property topicsToReplicates List of regular expression patterns indicating the topics to copy.
 */
public data class ReplicatorReplicationInfoListTopicReplicationArgs(
    public val copyAccessControlListsForTopics: Output<Boolean>? = null,
    public val copyTopicConfigurations: Output<Boolean>? = null,
    public val detectAndCopyNewTopics: Output<Boolean>? = null,
    public val topicsToExcludes: Output<List<String>>? = null,
    public val topicsToReplicates: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationArgs =
        com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationArgs.builder()
            .copyAccessControlListsForTopics(copyAccessControlListsForTopics?.applyValue({ args0 -> args0 }))
            .copyTopicConfigurations(copyTopicConfigurations?.applyValue({ args0 -> args0 }))
            .detectAndCopyNewTopics(detectAndCopyNewTopics?.applyValue({ args0 -> args0 }))
            .topicsToExcludes(topicsToExcludes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .topicsToReplicates(topicsToReplicates.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ReplicatorReplicationInfoListTopicReplicationArgs].
 */
@PulumiTagMarker
public class ReplicatorReplicationInfoListTopicReplicationArgsBuilder internal constructor() {
    private var copyAccessControlListsForTopics: Output<Boolean>? = null

    private var copyTopicConfigurations: Output<Boolean>? = null

    private var detectAndCopyNewTopics: Output<Boolean>? = null

    private var topicsToExcludes: Output<List<String>>? = null

    private var topicsToReplicates: Output<List<String>>? = null

    /**
     * @param value Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
     */
    @JvmName("hhrugggedggqprvd")
    public suspend fun copyAccessControlListsForTopics(`value`: Output<Boolean>) {
        this.copyAccessControlListsForTopics = value
    }

    /**
     * @param value Whether to periodically configure remote topics to match their corresponding upstream topics.
     */
    @JvmName("iefwyckcyttlglli")
    public suspend fun copyTopicConfigurations(`value`: Output<Boolean>) {
        this.copyTopicConfigurations = value
    }

    /**
     * @param value Whether to periodically check for new topics and partitions.
     */
    @JvmName("asjtdyhvhjbfuvmm")
    public suspend fun detectAndCopyNewTopics(`value`: Output<Boolean>) {
        this.detectAndCopyNewTopics = value
    }

    /**
     * @param value List of regular expression patterns indicating the topics that should not be replica.
     */
    @JvmName("ptcbdeadvxnboysd")
    public suspend fun topicsToExcludes(`value`: Output<List<String>>) {
        this.topicsToExcludes = value
    }

    @JvmName("gbwrkvpyygstuilr")
    public suspend fun topicsToExcludes(vararg values: Output<String>) {
        this.topicsToExcludes = Output.all(values.asList())
    }

    /**
     * @param values List of regular expression patterns indicating the topics that should not be replica.
     */
    @JvmName("tjhcjsnbtnbydiyd")
    public suspend fun topicsToExcludes(values: List<Output<String>>) {
        this.topicsToExcludes = Output.all(values)
    }

    /**
     * @param value List of regular expression patterns indicating the topics to copy.
     */
    @JvmName("ejsmwntfdweulbwf")
    public suspend fun topicsToReplicates(`value`: Output<List<String>>) {
        this.topicsToReplicates = value
    }

    @JvmName("fwlyamabgmitbmso")
    public suspend fun topicsToReplicates(vararg values: Output<String>) {
        this.topicsToReplicates = Output.all(values.asList())
    }

    /**
     * @param values List of regular expression patterns indicating the topics to copy.
     */
    @JvmName("jywsqfxbftihmudh")
    public suspend fun topicsToReplicates(values: List<Output<String>>) {
        this.topicsToReplicates = Output.all(values)
    }

    /**
     * @param value Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
     */
    @JvmName("fjwhocdddiycuxgq")
    public suspend fun copyAccessControlListsForTopics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyAccessControlListsForTopics = mapped
    }

    /**
     * @param value Whether to periodically configure remote topics to match their corresponding upstream topics.
     */
    @JvmName("kptdtfxwwvmxhlly")
    public suspend fun copyTopicConfigurations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTopicConfigurations = mapped
    }

    /**
     * @param value Whether to periodically check for new topics and partitions.
     */
    @JvmName("rovpwupbvsaxiugo")
    public suspend fun detectAndCopyNewTopics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectAndCopyNewTopics = mapped
    }

    /**
     * @param value List of regular expression patterns indicating the topics that should not be replica.
     */
    @JvmName("bsusiatbagvrquar")
    public suspend fun topicsToExcludes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicsToExcludes = mapped
    }

    /**
     * @param values List of regular expression patterns indicating the topics that should not be replica.
     */
    @JvmName("tpcfkyikogwmtvfr")
    public suspend fun topicsToExcludes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicsToExcludes = mapped
    }

    /**
     * @param value List of regular expression patterns indicating the topics to copy.
     */
    @JvmName("hxltlukymmcjmvlo")
    public suspend fun topicsToReplicates(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicsToReplicates = mapped
    }

    /**
     * @param values List of regular expression patterns indicating the topics to copy.
     */
    @JvmName("jxjhhypukdkuufwq")
    public suspend fun topicsToReplicates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicsToReplicates = mapped
    }

    internal fun build(): ReplicatorReplicationInfoListTopicReplicationArgs =
        ReplicatorReplicationInfoListTopicReplicationArgs(
            copyAccessControlListsForTopics = copyAccessControlListsForTopics,
            copyTopicConfigurations = copyTopicConfigurations,
            detectAndCopyNewTopics = detectAndCopyNewTopics,
            topicsToExcludes = topicsToExcludes,
            topicsToReplicates = topicsToReplicates ?: throw PulumiNullFieldException("topicsToReplicates"),
        )
}
