@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslIamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether SASL/IAM authentication is enabled or not.
 */
public data class ServerlessClusterClientAuthenticationSaslIamArgs(
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslIamArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslIamArgs =
        com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslIamArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessClusterClientAuthenticationSaslIamArgs].
 */
@PulumiTagMarker
public class ServerlessClusterClientAuthenticationSaslIamArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether SASL/IAM authentication is enabled or not.
     */
    @JvmName("noaqcqokidjnvmmn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether SASL/IAM authentication is enabled or not.
     */
    @JvmName("udbnkqpgvapllnrr")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ServerlessClusterClientAuthenticationSaslIamArgs =
        ServerlessClusterClientAuthenticationSaslIamArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
