@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ServerlessClusterVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds Specifies up to five security groups that control inbound and outbound traffic for the serverless cluster.
 * @property subnetIds A list of subnets in at least two different Availability Zones that host your client applications.
 */
public data class ServerlessClusterVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ServerlessClusterVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ServerlessClusterVpcConfigArgs =
        com.pulumi.aws.msk.inputs.ServerlessClusterVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ServerlessClusterVpcConfigArgs].
 */
@PulumiTagMarker
public class ServerlessClusterVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value Specifies up to five security groups that control inbound and outbound traffic for the serverless cluster.
     */
    @JvmName("wfktynffpcaotlsk")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("anrqyjcfridgvmud")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Specifies up to five security groups that control inbound and outbound traffic for the serverless cluster.
     */
    @JvmName("npshxqwqyjeivipt")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A list of subnets in at least two different Availability Zones that host your client applications.
     */
    @JvmName("jbecympkcyfcdgvj")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("qwctkidhnuhyjrbo")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of subnets in at least two different Availability Zones that host your client applications.
     */
    @JvmName("msteouayjmqqpucf")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Specifies up to five security groups that control inbound and outbound traffic for the serverless cluster.
     */
    @JvmName("ydwbjwbqucwecrer")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Specifies up to five security groups that control inbound and outbound traffic for the serverless cluster.
     */
    @JvmName("sowqkvkvsopeioxu")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A list of subnets in at least two different Availability Zones that host your client applications.
     */
    @JvmName("vjbshiykkegrccri")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of subnets in at least two different Availability Zones that host your client applications.
     */
    @JvmName("jvvpndmgpsibdqno")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): ServerlessClusterVpcConfigArgs = ServerlessClusterVpcConfigArgs(
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
    )
}
