@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property provisionedThroughput A block that contains EBS volume provisioned throughput information. To provision storage throughput, you must choose broker type kafka.m5.4xlarge or larger. See below.
 * @property volumeSize The size in GiB of the EBS volume for the data drive on each broker node. Minimum value of `1` and maximum value of `16384`.
 */
public data class ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo(
    public val provisionedThroughput:
    ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput? = null,
    public val volumeSize: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo):
            ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo =
            ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo(
                provisionedThroughput = javaType.provisionedThroughput().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.msk.kotlin.outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                volumeSize = javaType.volumeSize().map({ args0 -> args0 }).orElse(null),
            )
    }
}
