@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property enabled Controls whether provisioned throughput is enabled or not. Default value: `false`.
 * @property volumeThroughput Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second. The minimum value is `250`. The maximum value varies between broker type. You can refer to the valid values for the maximum volume throughput at the following [documentation on throughput bottlenecks](https://docs.aws.amazon.com/msk/latest/developerguide/msk-provision-throughput.html#throughput-bottlenecks)
 */
public data class ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput(
    public val enabled: Boolean? = null,
    public val volumeThroughput: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput):
            ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput =
            ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                volumeThroughput = javaType.volumeThroughput().map({ args0 -> args0 }).orElse(null),
            )
    }
}
