@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property sasl Configuration block for specifying SASL client authentication. See below.
 * @property tls Configuration block for specifying TLS client authentication. See below.
 * @property unauthenticated Enables unauthenticated access.
 */
public data class ClusterClientAuthentication(
    public val sasl: ClusterClientAuthenticationSasl? = null,
    public val tls: ClusterClientAuthenticationTls? = null,
    public val unauthenticated: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterClientAuthentication):
            ClusterClientAuthentication = ClusterClientAuthentication(
            sasl = javaType.sasl().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.ClusterClientAuthenticationSasl.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tls = javaType.tls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.ClusterClientAuthenticationTls.Companion.toKotlin(args0)
                })
            }).orElse(null),
            unauthenticated = javaType.unauthenticated().map({ args0 -> args0 }).orElse(null),
        )
    }
}
