@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property iam Enables IAM client authentication. Defaults to `false`.
 * @property scram Enables SCRAM client authentication via AWS Secrets Manager. Defaults to `false`.
 */
public data class ClusterClientAuthenticationSasl(
    public val iam: Boolean? = null,
    public val scram: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterClientAuthenticationSasl):
            ClusterClientAuthenticationSasl = ClusterClientAuthenticationSasl(
            iam = javaType.iam().map({ args0 -> args0 }).orElse(null),
            scram = javaType.scram().map({ args0 -> args0 }).orElse(null),
        )
    }
}
