@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
 * @property revision Revision of the MSK Configuration to use in the cluster.
 */
public data class ClusterConfigurationInfo(
    public val arn: String,
    public val revision: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterConfigurationInfo):
            ClusterConfigurationInfo = ClusterConfigurationInfo(
            arn = javaType.arn(),
            revision = javaType.revision(),
        )
    }
}
