@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encryptionAtRestKmsKeyArn You may specify a KMS key short ID or ARN (it will always output an ARN) to use for encrypting your data at rest.  If no key is specified, an AWS managed KMS ('aws/msk' managed service) key will be used for encrypting the data at rest.
 * @property encryptionInTransit Configuration block to specify encryption in transit. See below.
 */
public data class ClusterEncryptionInfo(
    public val encryptionAtRestKmsKeyArn: String? = null,
    public val encryptionInTransit: ClusterEncryptionInfoEncryptionInTransit? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterEncryptionInfo):
            ClusterEncryptionInfo = ClusterEncryptionInfo(
            encryptionAtRestKmsKeyArn = javaType.encryptionAtRestKmsKeyArn().map({ args0 ->
                args0
            }).orElse(null),
            encryptionInTransit = javaType.encryptionInTransit().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.ClusterEncryptionInfoEncryptionInTransit.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
