@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientBroker Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`. Default value is `TLS`.
 * @property inCluster Whether data communication among broker nodes is encrypted. Default value: `true`.
 */
public data class ClusterEncryptionInfoEncryptionInTransit(
    public val clientBroker: String? = null,
    public val inCluster: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterEncryptionInfoEncryptionInTransit):
            ClusterEncryptionInfoEncryptionInTransit = ClusterEncryptionInfoEncryptionInTransit(
            clientBroker = javaType.clientBroker().map({ args0 -> args0 }).orElse(null),
            inCluster = javaType.inCluster().map({ args0 -> args0 }).orElse(null),
        )
    }
}
