@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Controls whether provisioned throughput is enabled or not. Default value: `false`.
 * @property logGroup Name of the Cloudwatch Log Group to deliver logs to.
 */
public data class ClusterLoggingInfoBrokerLogsCloudwatchLogs(
    public val enabled: Boolean,
    public val logGroup: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterLoggingInfoBrokerLogsCloudwatchLogs):
            ClusterLoggingInfoBrokerLogsCloudwatchLogs = ClusterLoggingInfoBrokerLogsCloudwatchLogs(
            enabled = javaType.enabled(),
            logGroup = javaType.logGroup().map({ args0 -> args0 }).orElse(null),
        )
    }
}
