@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deliveryStream Name of the Kinesis Data Firehose delivery stream to deliver logs to.
 * @property enabled Controls whether provisioned throughput is enabled or not. Default value: `false`.
 */
public data class ClusterLoggingInfoBrokerLogsFirehose(
    public val deliveryStream: String? = null,
    public val enabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterLoggingInfoBrokerLogsFirehose):
            ClusterLoggingInfoBrokerLogsFirehose = ClusterLoggingInfoBrokerLogsFirehose(
            deliveryStream = javaType.deliveryStream().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
        )
    }
}
