@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket Name of the S3 bucket to deliver logs to.
 * @property enabled Controls whether provisioned throughput is enabled or not. Default value: `false`.
 * @property prefix Prefix to append to the folder name.
 */
public data class ClusterLoggingInfoBrokerLogsS3(
    public val bucket: String? = null,
    public val enabled: Boolean,
    public val prefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterLoggingInfoBrokerLogsS3):
            ClusterLoggingInfoBrokerLogsS3 = ClusterLoggingInfoBrokerLogsS3(
            bucket = javaType.bucket().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
