@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBrokerNodes.
 * @property clusterArn
 * @property id The provider-assigned unique ID for this managed resource.
 * @property nodeInfoLists
 */
public data class GetBrokerNodesResult(
    public val clusterArn: String,
    public val id: String,
    public val nodeInfoLists: List<GetBrokerNodesNodeInfoList>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.GetBrokerNodesResult):
            GetBrokerNodesResult = GetBrokerNodesResult(
            clusterArn = javaType.clusterArn(),
            id = javaType.id(),
            nodeInfoLists = javaType.nodeInfoLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.GetBrokerNodesNodeInfoList.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
