@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getConfiguration.
 * @property arn ARN of the configuration.
 * @property description Description of the configuration.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kafkaVersions List of Apache Kafka versions which can use this configuration.
 * @property latestRevision Latest revision of the configuration.
 * @property name
 * @property serverProperties Contents of the server.properties file.
 */
public data class GetConfigurationResult(
    public val arn: String,
    public val description: String,
    public val id: String,
    public val kafkaVersions: List<String>,
    public val latestRevision: Int,
    public val name: String,
    public val serverProperties: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.GetConfigurationResult):
            GetConfigurationResult = GetConfigurationResult(
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            kafkaVersions = javaType.kafkaVersions().map({ args0 -> args0 }),
            latestRevision = javaType.latestRevision(),
            name = javaType.name(),
            serverProperties = javaType.serverProperties(),
        )
    }
}
