@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getKafkaVersion.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property preferredVersions
 * @property status Status of the MSK Kafka version eg. `ACTIVE` or `DEPRECATED`.
 * @property version
 */
public data class GetKafkaVersionResult(
    public val id: String,
    public val preferredVersions: List<String>? = null,
    public val status: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.GetKafkaVersionResult):
            GetKafkaVersionResult = GetKafkaVersionResult(
            id = javaType.id(),
            preferredVersions = javaType.preferredVersions().map({ args0 -> args0 }),
            status = javaType.status(),
            version = javaType.version(),
        )
    }
}
