@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property amazonMskCluster Details of an Amazon MSK cluster.
 * @property vpcConfig Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
 */
public data class ReplicatorKafkaCluster(
    public val amazonMskCluster: ReplicatorKafkaClusterAmazonMskCluster,
    public val vpcConfig: ReplicatorKafkaClusterVpcConfig,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ReplicatorKafkaCluster):
            ReplicatorKafkaCluster = ReplicatorKafkaCluster(
            amazonMskCluster = javaType.amazonMskCluster().let({ args0 ->
                com.pulumi.aws.msk.kotlin.outputs.ReplicatorKafkaClusterAmazonMskCluster.Companion.toKotlin(args0)
            }),
            vpcConfig = javaType.vpcConfig().let({ args0 ->
                com.pulumi.aws.msk.kotlin.outputs.ReplicatorKafkaClusterVpcConfig.Companion.toKotlin(args0)
            }),
        )
    }
}
