@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property copyAccessControlListsForTopics Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
 * @property copyTopicConfigurations Whether to periodically configure remote topics to match their corresponding upstream topics.
 * @property detectAndCopyNewTopics Whether to periodically check for new topics and partitions.
 * @property topicsToExcludes List of regular expression patterns indicating the topics that should not be replica.
 * @property topicsToReplicates List of regular expression patterns indicating the topics to copy.
 */
public data class ReplicatorReplicationInfoListTopicReplication(
    public val copyAccessControlListsForTopics: Boolean? = null,
    public val copyTopicConfigurations: Boolean? = null,
    public val detectAndCopyNewTopics: Boolean? = null,
    public val topicsToExcludes: List<String>? = null,
    public val topicsToReplicates: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ReplicatorReplicationInfoListTopicReplication):
            ReplicatorReplicationInfoListTopicReplication =
            ReplicatorReplicationInfoListTopicReplication(
                copyAccessControlListsForTopics = javaType.copyAccessControlListsForTopics().map({ args0 ->
                    args0
                }).orElse(null),
                copyTopicConfigurations = javaType.copyTopicConfigurations().map({ args0 -> args0 }).orElse(null),
                detectAndCopyNewTopics = javaType.detectAndCopyNewTopics().map({ args0 -> args0 }).orElse(null),
                topicsToExcludes = javaType.topicsToExcludes().map({ args0 -> args0 }),
                topicsToReplicates = javaType.topicsToReplicates().map({ args0 -> args0 }),
            )
    }
}
