@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds Specifies up to five security groups that control inbound and outbound traffic for the serverless cluster.
 * @property subnetIds A list of subnets in at least two different Availability Zones that host your client applications.
 */
public data class ServerlessClusterVpcConfig(
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ServerlessClusterVpcConfig):
            ServerlessClusterVpcConfig = ServerlessClusterVpcConfig(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
