@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorCapacity
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaCluster
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaClusterClientAuthentication
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaClusterEncryptionInTransit
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorLogDelivery
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorPlugin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorWorkerConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorCapacity.Companion.toKotlin as connectorCapacityToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaCluster.Companion.toKotlin as connectorKafkaClusterToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaClusterClientAuthentication.Companion.toKotlin as connectorKafkaClusterClientAuthenticationToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaClusterEncryptionInTransit.Companion.toKotlin as connectorKafkaClusterEncryptionInTransitToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorLogDelivery.Companion.toKotlin as connectorLogDeliveryToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorPlugin.Companion.toKotlin as connectorPluginToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorWorkerConfiguration.Companion.toKotlin as connectorWorkerConfigurationToKotlin

/**
 * Builder for [Connector].
 */
@PulumiTagMarker
public class ConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectorArgs = ConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectorArgsBuilder.() -> Unit) {
        val builder = ConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Connector {
        val builtJavaResource = com.pulumi.aws.mskconnect.Connector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connector(builtJavaResource)
    }
}

/**
 * Provides an Amazon MSK Connect Connector resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mskconnect.Connector;
 * import com.pulumi.aws.mskconnect.ConnectorArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleInPolicyArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleOutPolicyArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterVpcArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterClientAuthenticationArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterEncryptionInTransitArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorPluginArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorPluginCustomPluginArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connector("example", ConnectorArgs.builder()
 *             .kafkaconnectVersion("2.7.1")
 *             .capacity(ConnectorCapacityArgs.builder()
 *                 .autoscaling(ConnectorCapacityAutoscalingArgs.builder()
 *                     .mcuCount(1)
 *                     .minWorkerCount(1)
 *                     .maxWorkerCount(2)
 *                     .scaleInPolicy(ConnectorCapacityAutoscalingScaleInPolicyArgs.builder()
 *                         .cpuUtilizationPercentage(20)
 *                         .build())
 *                     .scaleOutPolicy(ConnectorCapacityAutoscalingScaleOutPolicyArgs.builder()
 *                         .cpuUtilizationPercentage(80)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .connectorConfiguration(Map.ofEntries(
 *                 Map.entry("connector.class", "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector"),
 *                 Map.entry("tasks.max", "1"),
 *                 Map.entry("topics", "example")
 *             ))
 *             .kafkaCluster(ConnectorKafkaClusterArgs.builder()
 *                 .apacheKafkaCluster(ConnectorKafkaClusterApacheKafkaClusterArgs.builder()
 *                     .bootstrapServers(aws_msk_cluster.example().bootstrap_brokers_tls())
 *                     .vpc(ConnectorKafkaClusterApacheKafkaClusterVpcArgs.builder()
 *                         .securityGroups(aws_security_group.example().id())
 *                         .subnets(
 *                             aws_subnet.example1().id(),
 *                             aws_subnet.example2().id(),
 *                             aws_subnet.example3().id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .kafkaClusterClientAuthentication(ConnectorKafkaClusterClientAuthenticationArgs.builder()
 *                 .authenticationType("NONE")
 *                 .build())
 *             .kafkaClusterEncryptionInTransit(ConnectorKafkaClusterEncryptionInTransitArgs.builder()
 *                 .encryptionType("TLS")
 *                 .build())
 *             .plugins(ConnectorPluginArgs.builder()
 *                 .customPlugin(ConnectorPluginCustomPluginArgs.builder()
 *                     .arn(aws_mskconnect_custom_plugin.example().arn())
 *                     .revision(aws_mskconnect_custom_plugin.example().latest_revision())
 *                     .build())
 *                 .build())
 *             .serviceExecutionRoleArn(aws_iam_role.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK Connect Connector using the connector's `arn`. For example:
 * ```sh
 *  $ pulumi import aws:mskconnect/connector:Connector example 'arn:aws:kafkaconnect:eu-central-1:123456789012:connector/example/264edee4-17a3-412e-bd76-6681cfc93805-3'
 * ```
 *
 */
public class Connector internal constructor(
    override val javaResource: com.pulumi.aws.mskconnect.Connector,
) : KotlinCustomResource(javaResource, ConnectorMapper) {
    /**
     * The Amazon Resource Name (ARN) of the custom plugin.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Information about the capacity allocated to the connector. See below.
     */
    public val capacity: Output<ConnectorCapacity>
        get() = javaResource.capacity().applyValue({ args0 ->
            args0.let({ args0 ->
                connectorCapacityToKotlin(args0)
            })
        })

    /**
     * A map of keys to values that represent the configuration for the connector.
     */
    public val connectorConfiguration: Output<Map<String, String>>
        get() = javaResource.connectorConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A summary description of the connector.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies which Apache Kafka cluster to connect to. See below.
     */
    public val kafkaCluster: Output<ConnectorKafkaCluster>
        get() = javaResource.kafkaCluster().applyValue({ args0 ->
            args0.let({ args0 ->
                connectorKafkaClusterToKotlin(args0)
            })
        })

    /**
     * Details of the client authentication used by the Apache Kafka cluster. See below.
     */
    public val kafkaClusterClientAuthentication: Output<ConnectorKafkaClusterClientAuthentication>
        get() = javaResource.kafkaClusterClientAuthentication().applyValue({ args0 ->
            args0.let({ args0 ->
                connectorKafkaClusterClientAuthenticationToKotlin(args0)
            })
        })

    /**
     * Details of encryption in transit to the Apache Kafka cluster. See below.
     */
    public val kafkaClusterEncryptionInTransit: Output<ConnectorKafkaClusterEncryptionInTransit>
        get() = javaResource.kafkaClusterEncryptionInTransit().applyValue({ args0 ->
            args0.let({ args0 ->
                connectorKafkaClusterEncryptionInTransitToKotlin(args0)
            })
        })

    /**
     * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    public val kafkaconnectVersion: Output<String>
        get() = javaResource.kafkaconnectVersion().applyValue({ args0 -> args0 })

    /**
     * Details about log delivery. See below.
     */
    public val logDelivery: Output<ConnectorLogDelivery>?
        get() = javaResource.logDelivery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectorLogDeliveryToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the connector.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies which plugins to use for the connector. See below.
     */
    public val plugins: Output<List<ConnectorPlugin>>
        get() = javaResource.plugins().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectorPluginToKotlin(args0)
                })
            })
        })

    /**
     * The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
     */
    public val serviceExecutionRoleArn: Output<String>
        get() = javaResource.serviceExecutionRoleArn().applyValue({ args0 -> args0 })

    /**
     * The current version of the connector.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * Specifies which worker configuration to use with the connector. See below.
     */
    public val workerConfiguration: Output<ConnectorWorkerConfiguration>?
        get() = javaResource.workerConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> connectorWorkerConfigurationToKotlin(args0) })
            }).orElse(null)
        })
}

public object ConnectorMapper : ResourceMapper<Connector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mskconnect.Connector::class == javaResource::class

    override fun map(javaResource: Resource): Connector = Connector(
        javaResource as
            com.pulumi.aws.mskconnect.Connector,
    )
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connector].
 */
public suspend fun connector(name: String, block: suspend ConnectorResourceBuilder.() -> Unit):
    Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connector(name: String): Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
