@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.ConnectorArgs.builder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorCapacityArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorCapacityArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterClientAuthenticationArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterClientAuthenticationArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterEncryptionInTransitArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterEncryptionInTransitArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorLogDeliveryArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorLogDeliveryArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorPluginArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorPluginArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorWorkerConfigurationArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorWorkerConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon MSK Connect Connector resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mskconnect.Connector;
 * import com.pulumi.aws.mskconnect.ConnectorArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleInPolicyArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleOutPolicyArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterVpcArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterClientAuthenticationArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterEncryptionInTransitArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorPluginArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorPluginCustomPluginArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connector("example", ConnectorArgs.builder()
 *             .kafkaconnectVersion("2.7.1")
 *             .capacity(ConnectorCapacityArgs.builder()
 *                 .autoscaling(ConnectorCapacityAutoscalingArgs.builder()
 *                     .mcuCount(1)
 *                     .minWorkerCount(1)
 *                     .maxWorkerCount(2)
 *                     .scaleInPolicy(ConnectorCapacityAutoscalingScaleInPolicyArgs.builder()
 *                         .cpuUtilizationPercentage(20)
 *                         .build())
 *                     .scaleOutPolicy(ConnectorCapacityAutoscalingScaleOutPolicyArgs.builder()
 *                         .cpuUtilizationPercentage(80)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .connectorConfiguration(Map.ofEntries(
 *                 Map.entry("connector.class", "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector"),
 *                 Map.entry("tasks.max", "1"),
 *                 Map.entry("topics", "example")
 *             ))
 *             .kafkaCluster(ConnectorKafkaClusterArgs.builder()
 *                 .apacheKafkaCluster(ConnectorKafkaClusterApacheKafkaClusterArgs.builder()
 *                     .bootstrapServers(aws_msk_cluster.example().bootstrap_brokers_tls())
 *                     .vpc(ConnectorKafkaClusterApacheKafkaClusterVpcArgs.builder()
 *                         .securityGroups(aws_security_group.example().id())
 *                         .subnets(
 *                             aws_subnet.example1().id(),
 *                             aws_subnet.example2().id(),
 *                             aws_subnet.example3().id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .kafkaClusterClientAuthentication(ConnectorKafkaClusterClientAuthenticationArgs.builder()
 *                 .authenticationType("NONE")
 *                 .build())
 *             .kafkaClusterEncryptionInTransit(ConnectorKafkaClusterEncryptionInTransitArgs.builder()
 *                 .encryptionType("TLS")
 *                 .build())
 *             .plugins(ConnectorPluginArgs.builder()
 *                 .customPlugin(ConnectorPluginCustomPluginArgs.builder()
 *                     .arn(aws_mskconnect_custom_plugin.example().arn())
 *                     .revision(aws_mskconnect_custom_plugin.example().latest_revision())
 *                     .build())
 *                 .build())
 *             .serviceExecutionRoleArn(aws_iam_role.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK Connect Connector using the connector's `arn`. For example:
 * ```sh
 *  $ pulumi import aws:mskconnect/connector:Connector example 'arn:aws:kafkaconnect:eu-central-1:123456789012:connector/example/264edee4-17a3-412e-bd76-6681cfc93805-3'
 * ```
 * @property capacity Information about the capacity allocated to the connector. See below.
 * @property connectorConfiguration A map of keys to values that represent the configuration for the connector.
 * @property description A summary description of the connector.
 * @property kafkaCluster Specifies which Apache Kafka cluster to connect to. See below.
 * @property kafkaClusterClientAuthentication Details of the client authentication used by the Apache Kafka cluster. See below.
 * @property kafkaClusterEncryptionInTransit Details of encryption in transit to the Apache Kafka cluster. See below.
 * @property kafkaconnectVersion The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
 * @property logDelivery Details about log delivery. See below.
 * @property name The name of the connector.
 * @property plugins Specifies which plugins to use for the connector. See below.
 * @property serviceExecutionRoleArn The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
 * @property workerConfiguration Specifies which worker configuration to use with the connector. See below.
 */
public data class ConnectorArgs(
    public val capacity: Output<ConnectorCapacityArgs>? = null,
    public val connectorConfiguration: Output<Map<String, String>>? = null,
    public val description: Output<String>? = null,
    public val kafkaCluster: Output<ConnectorKafkaClusterArgs>? = null,
    public val kafkaClusterClientAuthentication:
    Output<ConnectorKafkaClusterClientAuthenticationArgs>? = null,
    public val kafkaClusterEncryptionInTransit: Output<ConnectorKafkaClusterEncryptionInTransitArgs>? =
        null,
    public val kafkaconnectVersion: Output<String>? = null,
    public val logDelivery: Output<ConnectorLogDeliveryArgs>? = null,
    public val name: Output<String>? = null,
    public val plugins: Output<List<ConnectorPluginArgs>>? = null,
    public val serviceExecutionRoleArn: Output<String>? = null,
    public val workerConfiguration: Output<ConnectorWorkerConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.ConnectorArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.ConnectorArgs =
        com.pulumi.aws.mskconnect.ConnectorArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectorConfiguration(
                connectorConfiguration?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .kafkaCluster(kafkaCluster?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kafkaClusterClientAuthentication(
                kafkaClusterClientAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .kafkaClusterEncryptionInTransit(
                kafkaClusterEncryptionInTransit?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .kafkaconnectVersion(kafkaconnectVersion?.applyValue({ args0 -> args0 }))
            .logDelivery(logDelivery?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .plugins(
                plugins?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceExecutionRoleArn(serviceExecutionRoleArn?.applyValue({ args0 -> args0 }))
            .workerConfiguration(
                workerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorArgs].
 */
@PulumiTagMarker
public class ConnectorArgsBuilder internal constructor() {
    private var capacity: Output<ConnectorCapacityArgs>? = null

    private var connectorConfiguration: Output<Map<String, String>>? = null

    private var description: Output<String>? = null

    private var kafkaCluster: Output<ConnectorKafkaClusterArgs>? = null

    private var kafkaClusterClientAuthentication:
        Output<ConnectorKafkaClusterClientAuthenticationArgs>? = null

    private var kafkaClusterEncryptionInTransit: Output<ConnectorKafkaClusterEncryptionInTransitArgs>? =
        null

    private var kafkaconnectVersion: Output<String>? = null

    private var logDelivery: Output<ConnectorLogDeliveryArgs>? = null

    private var name: Output<String>? = null

    private var plugins: Output<List<ConnectorPluginArgs>>? = null

    private var serviceExecutionRoleArn: Output<String>? = null

    private var workerConfiguration: Output<ConnectorWorkerConfigurationArgs>? = null

    /**
     * @param value Information about the capacity allocated to the connector. See below.
     */
    @JvmName("unbelwdgdcghqlcc")
    public suspend fun capacity(`value`: Output<ConnectorCapacityArgs>) {
        this.capacity = value
    }

    /**
     * @param value A map of keys to values that represent the configuration for the connector.
     */
    @JvmName("mjhmgnjgflasrkpj")
    public suspend fun connectorConfiguration(`value`: Output<Map<String, String>>) {
        this.connectorConfiguration = value
    }

    /**
     * @param value A summary description of the connector.
     */
    @JvmName("idaxcxtrtondrtlx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies which Apache Kafka cluster to connect to. See below.
     */
    @JvmName("nnbwywqtvbigvyrk")
    public suspend fun kafkaCluster(`value`: Output<ConnectorKafkaClusterArgs>) {
        this.kafkaCluster = value
    }

    /**
     * @param value Details of the client authentication used by the Apache Kafka cluster. See below.
     */
    @JvmName("kqbvgtbirpltrkar")
    public suspend
    fun kafkaClusterClientAuthentication(`value`: Output<ConnectorKafkaClusterClientAuthenticationArgs>) {
        this.kafkaClusterClientAuthentication = value
    }

    /**
     * @param value Details of encryption in transit to the Apache Kafka cluster. See below.
     */
    @JvmName("bnrvebwaggwvleuj")
    public suspend
    fun kafkaClusterEncryptionInTransit(`value`: Output<ConnectorKafkaClusterEncryptionInTransitArgs>) {
        this.kafkaClusterEncryptionInTransit = value
    }

    /**
     * @param value The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    @JvmName("aaonewktehdtnkml")
    public suspend fun kafkaconnectVersion(`value`: Output<String>) {
        this.kafkaconnectVersion = value
    }

    /**
     * @param value Details about log delivery. See below.
     */
    @JvmName("ruvrvpvicgiqpryy")
    public suspend fun logDelivery(`value`: Output<ConnectorLogDeliveryArgs>) {
        this.logDelivery = value
    }

    /**
     * @param value The name of the connector.
     */
    @JvmName("opiklwnrueuvkogb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies which plugins to use for the connector. See below.
     */
    @JvmName("nejxebbukiqkasdh")
    public suspend fun plugins(`value`: Output<List<ConnectorPluginArgs>>) {
        this.plugins = value
    }

    @JvmName("dmnaswkrerohywlg")
    public suspend fun plugins(vararg values: Output<ConnectorPluginArgs>) {
        this.plugins = Output.all(values.asList())
    }

    /**
     * @param values Specifies which plugins to use for the connector. See below.
     */
    @JvmName("lvclprcllewvkify")
    public suspend fun plugins(values: List<Output<ConnectorPluginArgs>>) {
        this.plugins = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
     */
    @JvmName("wonlwkrhnolllafv")
    public suspend fun serviceExecutionRoleArn(`value`: Output<String>) {
        this.serviceExecutionRoleArn = value
    }

    /**
     * @param value Specifies which worker configuration to use with the connector. See below.
     */
    @JvmName("dnfteisillrgjgrf")
    public suspend fun workerConfiguration(`value`: Output<ConnectorWorkerConfigurationArgs>) {
        this.workerConfiguration = value
    }

    /**
     * @param value Information about the capacity allocated to the connector. See below.
     */
    @JvmName("hxmtrskpkkwncubp")
    public suspend fun capacity(`value`: ConnectorCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param argument Information about the capacity allocated to the connector. See below.
     */
    @JvmName("opgedmysttrdwtvj")
    public suspend fun capacity(argument: suspend ConnectorCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacity = mapped
    }

    /**
     * @param value A map of keys to values that represent the configuration for the connector.
     */
    @JvmName("pascgecqfovvufnn")
    public suspend fun connectorConfiguration(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorConfiguration = mapped
    }

    /**
     * @param values A map of keys to values that represent the configuration for the connector.
     */
    @JvmName("dyoaandyhyiadsex")
    public fun connectorConfiguration(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorConfiguration = mapped
    }

    /**
     * @param value A summary description of the connector.
     */
    @JvmName("turkoqyakehvxggj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies which Apache Kafka cluster to connect to. See below.
     */
    @JvmName("bbkxmtolqwxkveae")
    public suspend fun kafkaCluster(`value`: ConnectorKafkaClusterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaCluster = mapped
    }

    /**
     * @param argument Specifies which Apache Kafka cluster to connect to. See below.
     */
    @JvmName("yccchlonmirblslx")
    public suspend fun kafkaCluster(argument: suspend ConnectorKafkaClusterArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorKafkaClusterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kafkaCluster = mapped
    }

    /**
     * @param value Details of the client authentication used by the Apache Kafka cluster. See below.
     */
    @JvmName("hmscpliveauxtyda")
    public suspend
    fun kafkaClusterClientAuthentication(`value`: ConnectorKafkaClusterClientAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaClusterClientAuthentication = mapped
    }

    /**
     * @param argument Details of the client authentication used by the Apache Kafka cluster. See below.
     */
    @JvmName("rmsqrprwpagfqwbr")
    public suspend
    fun kafkaClusterClientAuthentication(argument: suspend ConnectorKafkaClusterClientAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorKafkaClusterClientAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kafkaClusterClientAuthentication = mapped
    }

    /**
     * @param value Details of encryption in transit to the Apache Kafka cluster. See below.
     */
    @JvmName("olhfvthorgebrykn")
    public suspend
    fun kafkaClusterEncryptionInTransit(`value`: ConnectorKafkaClusterEncryptionInTransitArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaClusterEncryptionInTransit = mapped
    }

    /**
     * @param argument Details of encryption in transit to the Apache Kafka cluster. See below.
     */
    @JvmName("gncjdrfqngnbdmpu")
    public suspend
    fun kafkaClusterEncryptionInTransit(argument: suspend ConnectorKafkaClusterEncryptionInTransitArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorKafkaClusterEncryptionInTransitArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kafkaClusterEncryptionInTransit = mapped
    }

    /**
     * @param value The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    @JvmName("wbdbwxwntqbhytks")
    public suspend fun kafkaconnectVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaconnectVersion = mapped
    }

    /**
     * @param value Details about log delivery. See below.
     */
    @JvmName("otllffmcxtocmnjp")
    public suspend fun logDelivery(`value`: ConnectorLogDeliveryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDelivery = mapped
    }

    /**
     * @param argument Details about log delivery. See below.
     */
    @JvmName("gkjsfiqjbtjrqyff")
    public suspend fun logDelivery(argument: suspend ConnectorLogDeliveryArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorLogDeliveryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logDelivery = mapped
    }

    /**
     * @param value The name of the connector.
     */
    @JvmName("bnsxhjclrmprcoui")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies which plugins to use for the connector. See below.
     */
    @JvmName("xmtapjhkvwcxcrnv")
    public suspend fun plugins(`value`: List<ConnectorPluginArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plugins = mapped
    }

    /**
     * @param argument Specifies which plugins to use for the connector. See below.
     */
    @JvmName("ncbykpggvskompxx")
    public suspend fun plugins(argument: List<suspend ConnectorPluginArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectorPluginArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.plugins = mapped
    }

    /**
     * @param argument Specifies which plugins to use for the connector. See below.
     */
    @JvmName("gurqvdnfyvthifeo")
    public suspend fun plugins(vararg argument: suspend ConnectorPluginArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectorPluginArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.plugins = mapped
    }

    /**
     * @param argument Specifies which plugins to use for the connector. See below.
     */
    @JvmName("dbvobbncmbjatxvb")
    public suspend fun plugins(argument: suspend ConnectorPluginArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConnectorPluginArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.plugins = mapped
    }

    /**
     * @param values Specifies which plugins to use for the connector. See below.
     */
    @JvmName("ytqkiypmavjtdncr")
    public suspend fun plugins(vararg values: ConnectorPluginArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.plugins = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
     */
    @JvmName("phwhfqaydedjhwya")
    public suspend fun serviceExecutionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceExecutionRoleArn = mapped
    }

    /**
     * @param value Specifies which worker configuration to use with the connector. See below.
     */
    @JvmName("bwnkfimiuhofmwru")
    public suspend fun workerConfiguration(`value`: ConnectorWorkerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerConfiguration = mapped
    }

    /**
     * @param argument Specifies which worker configuration to use with the connector. See below.
     */
    @JvmName("logfegvnwfafuuam")
    public suspend
    fun workerConfiguration(argument: suspend ConnectorWorkerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorWorkerConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workerConfiguration = mapped
    }

    internal fun build(): ConnectorArgs = ConnectorArgs(
        capacity = capacity,
        connectorConfiguration = connectorConfiguration,
        description = description,
        kafkaCluster = kafkaCluster,
        kafkaClusterClientAuthentication = kafkaClusterClientAuthentication,
        kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit,
        kafkaconnectVersion = kafkaconnectVersion,
        logDelivery = logDelivery,
        name = name,
        plugins = plugins,
        serviceExecutionRoleArn = serviceExecutionRoleArn,
        workerConfiguration = workerConfiguration,
    )
}
